<?php
namespace App\Controllers\Admin;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\Kkmodel;
use App\Models\Diskonmodel;

class Diskon extends BaseController
{
    use ResponseTrait;

    private $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) 
    {
        parent::initController($request, $response, $logger);
        $this->user = service("user_data");
    }

    private function check_access(){
        $user = service("user_data");
        if($user->data->group != 'admin'){
            return false;
        }else{
            return true;
        }
    }

    public function index(){
        $data['user'] = $this->user->data;
        return view('admin/diskon/index',$data);
    }

    public function detail($id_kk) {
        $data['user'] = $this->user->data;
        $tmodel = new Kkmodel();
        $builder = $tmodel->builder('vkk');
        $builder->where('id_kk',$id_kk);
        $data['kk'] = $builder->get()->getRow();
        
        $diskon_model = new Diskonmodel();
        $data['diskon_kk'] = $diskon_model->getDiskonKK($id_kk);
        return view('admin/diskon/detail',$data);
    }

    public function ajax_dt_kk(){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];

        $DataModel = new Diskonmodel();
        return $DataModel->GetDTKK($data_post,"");
    }

    public function ajax_dt($id_kk){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];
        $DataModel = new Diskonmodel();
        $extra = "(id_kk = ".$id_kk.")";
        return $DataModel->GetDT($data_post, $extra);
    }

    public function add($id_kk) {
        $data['user'] = $this->user->data;
        $model_kk = new Kkmodel();
        $builder = $model_kk->builder('vkk');
        $builder->where('id_kk',$id_kk);
        $data['kk'] = $builder->get()->getRow();

        return view('admin/diskon/add',$data);
    }

    public function add_save($id_kk)
    {
        $data = array();
        $data['status'] = 'success';

        $request = [
            'id_kk' => $id_kk,
            'nominal' => $this->request->getPost('nominal',FILTER_SANITIZE_ADD_SLASHES),
            'start_date' => $this->request->getPost('start_date',FILTER_SANITIZE_ADD_SLASHES),
            'end_date' => $this->request->getPost('end_date',FILTER_SANITIZE_ADD_SLASHES),
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'created_by' => $this->user->data->id_auth,
            'updated_by' => $this->user->data->id_auth
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('id_kk', 'KK', 'required');
        $validation->setRule('start_date', 'Start Date', 'required');
        $validation->setRule('end_date', 'End Date', 'required');
        $validation->setRule('keterangan', 'Keterangan', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            //die(var_dump($request));
            $diskon_model = new Diskonmodel();
            if ($diskon_model->insert($request, false))
            {
                $id = $diskon_model->getInsertID();
                if($request['end_date'] == "9999-12-31"){
                    $builder = $diskon_model->builder();
                    $builder->where("end_date","9999-12-31");
                    $builder->where("id_diskon !=",$id);
                    $builder->update(["end_date" => date("Y-m-d")]);
                }

                return $this->respond($data,200);
            }else{
                return $this->fail($diskon_model->errors(),400,null,'db');
            }
        }
    }

    public function view($id) {
        $data['user'] = $this->user->data;
        $tmodel = new Diskonmodel();
        $builder = $tmodel->builder("vdiskon");
        $data['diskon'] = $builder->where("id_diskon",$id)->get()->getRow();
        
        return view('admin/diskon/view',$data);
    }

    public function update()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);
        $request = [
            'nominal' => $this->request->getPost('nominal',FILTER_SANITIZE_ADD_SLASHES),
            'start_date' => $this->request->getPost('start_date',FILTER_SANITIZE_ADD_SLASHES),
            'end_date' => $this->request->getPost('end_date',FILTER_SANITIZE_ADD_SLASHES),
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'updated_by' => $this->user->data->id_auth
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('start_date', 'Start Date', 'required');
        $validation->setRule('end_date', 'End Date', 'required');
        $validation->setRule('keterangan', 'Keterangan', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Diskonmodel();
            if ($tmodel->update($id,$request))
            {
                return $this->respond($data,200);
            }else{
                return $this->fail(["error" => "Database Error!"],400,null,'db');
            }
        }
    }

    public function delete()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);

        $tmodel = new Diskonmodel();
        if ($tmodel->delete($id))
        {
            return $this->respond($data,200);
        }else{
            return $this->fail(["error" => "Database Error!"],400,null,'db');
        }
    }
}
?>