<?php
namespace App\Controllers\Admin;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\Kkmodel;
use App\Models\Tunggakanmodel;
use App\Models\Historytransmodel;

class Historytrans extends BaseController
{
    use ResponseTrait;

    private $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) 
    {
        parent::initController($request, $response, $logger);
        $this->user = service("user_data");
    }

    private function check_access(){
        $user = service("user_data");
        if($user->data->group != 'admin'){
            return false;
        }else{
            return true;
        }
    }

    public function index(){
        $data['user'] = $this->user->data;
        return view('admin/historytrans/index',$data);
    }

    public function detail($id_kk) {
        $data['user'] = $this->user->data;
        $tmodel = new Kkmodel();
        $builder = $tmodel->builder('vkk');
        $builder->where('id_kk',$id_kk);
        $data['kk'] = $builder->get()->getRow();
        
        return view('admin/historytrans/detail',$data);
    }

    public function ajax_dt_kk(){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];

        $DataModel = new Kkmodel();
        return $DataModel->GetDT($data_post,"");
    }

    public function ajax_dt($id_kk){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];
        $DataModel = new Historytransmodel();
        $extra = "(id_kk = ".$id_kk.")";
        return $DataModel->GetDT($data_post, $extra);
    }

    public function add($id_kk) {
        $data['user'] = $this->user->data;
        $model_kk = new Kkmodel();
        $builder = $model_kk->builder('vkk');
        $builder->where('id_kk',$id_kk);
        $data['kk'] = $builder->get()->getRow();

        return view('admin/historytrans/add',$data);
    }

    public function add_save($id_kk)
    {
        $data = array();
        $data['status'] = 'success';

        $periode = $this->request->getPost('periode',FILTER_SANITIZE_ADD_SLASHES);
        $arr_periode = explode("-",$periode);

        $request = [
            'id_kk' => $id_kk,
            'bulan' => $arr_periode[1],
            'tahun' => $arr_periode[0],
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'created_by' => $this->user->data->id_auth,
            'updated_by' => $this->user->data->id_auth
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('id_kk', 'KK', 'required');
        $validation->setRule('keterangan', 'Keterangan', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            //die(var_dump($request));
            $historytransmodel = new Historytransmodel();
            if ($historytransmodel->insert($request, false))
            {
                return $this->respond($data,200);
            }else{
                return $this->fail($historytransmodel->errors(),400,null,'db');
            }
        }
    }

    public function view($id) {
        $data['user'] = $this->user->data;
        $tmodel = new Historytransmodel();
        $builder = $tmodel->builder("vhistorytrans");
        $data['historytrans'] = $builder->where("id_history_trans",$id)->get()->getRow();
        
        return view('admin/historytrans/view',$data);
    }

    public function update()
    {
        $data = array();
        $data['status'] = 'success';

        $periode = $this->request->getPost('periode',FILTER_SANITIZE_ADD_SLASHES);
        $arr_periode = explode("-",$periode);

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);
        $request = [
            'bulan' => $arr_periode[1],
            'tahun' => $arr_periode[0],
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'updated_by' => $this->user->data->id_auth
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('keterangan', 'Keterangan', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Historytransmodel();
            if ($tmodel->update($id,$request))
            {
                return $this->respond($data,200);
            }else{
                return $this->fail(["error" => "Database Error!"],400,null,'db');
            }
        }
    }

    public function delete()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);

        $tmodel = new Historytransmodel();
        if ($tmodel->delete($id))
        {
            return $this->respond($data,200);
        }else{
            return $this->fail(["error" => "Database Error!"],400,null,'db');
        }
    }
}
?>