<?php
namespace App\Controllers\Admin;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\Jeniskkmodel;
use App\Models\Gruptransaksimodel;
use App\Models\Iuranmodel;

class Iuran extends BaseController
{
    use ResponseTrait;

    private $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) 
    {
        parent::initController($request, $response, $logger);
        $this->user = service("user_data");
    }

    private function check_access(){
        $user = service("user_data");
        if($user->data->group != 'admin'){
            return false;
        }else{
            return true;
        }
    }

    public function index(){
        $data['user'] = $this->user->data;
        return view('admin/iuran/index',$data);
    }

    public function ajax_dt(){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];
        $DataModel = new Iuranmodel();
        return $DataModel->GetDT($data_post,"");
    }

    public function add() {
        $data['user'] = $this->user->data;
        
        // $jkk_model = new Jeniskkmodel();
        // $gruptransaksi_model = new Gruptransaksimodel();

        // $data['jenis_kk'] = $jkk_model->findAll();
        // $data['grup_transaksi'] = $gruptransaksi_model->findAll();

        return view('admin/iuran/add',$data);
    }

    public function add_save()
    {
        $data = array();
        $data['status'] = 'success';

        $request = [
            'id_grup_transaksi' => $this->request->getPost('id_grup_transaksi',FILTER_SANITIZE_ADD_SLASHES),
            'id_jenis_kk' => $this->request->getPost('id_jenis_kk',FILTER_SANITIZE_ADD_SLASHES),
            'nominal' => $this->request->getPost('nominal',FILTER_SANITIZE_ADD_SLASHES),
            'status' => $this->request->getPost('status',FILTER_SANITIZE_ADD_SLASHES),
            'start_date' => $this->request->getPost('start_date',FILTER_SANITIZE_ADD_SLASHES),
            'end_date' => $this->request->getPost('end_date',FILTER_SANITIZE_ADD_SLASHES),
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'created_by' => $this->user->data->id_auth,
            'updated_by' => $this->user->data->id_auth
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('id_grup_transaksi', 'Grup Transaksi', 'required');
        $validation->setRule('id_jenis_kk', 'Jenis KK', 'required');
        $validation->setRule('nominal', 'Nominal', 'required');
        $validation->setRule('start_date', 'Start Date', 'required');
        $validation->setRule('end_date', 'End Date', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Iuranmodel();
            $tmodel->db->transBegin();
            $id = $tmodel->insert($request);
            if($tmodel->db->transStatus() === false){
                $tmodel->db->transRollback();
                return $this->fail($tmodel->errors(),400,null,'db');
            }else{
                $tmodel->db->transCommit();
                if($request['status'] == 'Aktif'){
                    $this->set_aktif_false($id, $request['id_grup_transaksi'], $request['id_jenis_kk']);
                }
                return $this->respond($data,200);
            }
        }
    }

    public function view($id) {
        $data['user'] = $this->user->data;
        $tmodel = new Iuranmodel();
        // $jkk_model = new Jeniskkmodel();
        // $grupbayar_model = new Gruptransaksimodel();

        // $data['jenis_kk'] = $jkk_model->findAll();
        // $data['grup_bayar'] = $grupbayar_model->findAll();

        $builder = $tmodel->builder("viuran");
        $data['data'] = $builder->where("id_iuran",$id)->get()->getRow();

        return view('admin/iuran/view',$data);
    }

    public function update()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);
        $request = [
            'id_grup_transaksi' => $this->request->getPost('id_grup_transaksi',FILTER_SANITIZE_ADD_SLASHES),
            'id_jenis_kk' => $this->request->getPost('id_jenis_kk',FILTER_SANITIZE_ADD_SLASHES),
            'nominal' => $this->request->getPost('nominal',FILTER_SANITIZE_ADD_SLASHES),
            'start_date' => $this->request->getPost('start_date',FILTER_SANITIZE_ADD_SLASHES),
            'end_date' => $this->request->getPost('end_date',FILTER_SANITIZE_ADD_SLASHES),
            'status' => $this->request->getPost('status',FILTER_SANITIZE_ADD_SLASHES),
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'updated_by' => $this->user->data->id_auth
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('id_grup_transaksi', 'Grup Transaksi', 'required');
        $validation->setRule('id_jenis_kk', 'Jenis KK', 'required');
        $validation->setRule('nominal', 'Nominal', 'required');
        $validation->setRule('start_date', 'Start Date', 'required');
        $validation->setRule('end_date', 'End Date', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Iuranmodel();

            if ($tmodel->update($id,$request))
            {
                if($request['status'] == 'Aktif'){
                    $this->set_aktif_false($id, $request['id_grup_transaksi'], $request['id_jenis_kk']);
                }
                return $this->respond($data,200);
            }else{
                return $this->fail(["error" => "Database Error!"],400,null,'db');
            }
        }
    }

    public function set_aktif_false($id, $id_grup_pembayaran, $id_jenis_kk)
    {
        $tmodel = new Iuranmodel();
        $builder = $tmodel->builder();
        $builder->set('status', 'Non Aktif');
        $builder->where('id_grup_transaksi', $id_grup_pembayaran);
        $builder->where('id_jenis_kk', $id_jenis_kk);
        $builder->where('id_iuran != ', $id);
        $builder->update();
    }

    public function delete()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);

        $tmodel = new Iuranmodel();
        if ($tmodel->delete($id))
        {
            return $this->respond($data,200);
        }else{
            return $this->fail(["error" => "Database Error!"],400,null,'db');
        }
    }
}
?>