<?php
namespace App\Controllers;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\Kkmodel;
use App\Models\Kolektormodel;
use App\Models\Operatormodel;
use App\Models\Tarifmodel;
use App\Models\Diskonmodel;
use App\Models\Invoicemodel;
use App\Models\Strukmodel;
use App\Models\Strukdetailmodel;
use App\Models\Transaksimodel;
use App\Models\Buktibayarmodel;
use App\Models\Jenispembayaranmodel;

use Dompdf\Dompdf;
use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;

class Transaksi extends BaseController
{
    use ResponseTrait;

    public function cetak_struk($id_struk){
        $data = array();
        $data["company_name"] = "PT Anugerah Cemara Abadi";

        $strukmodel = new Strukmodel();
        $strukbuilder = $strukmodel->builder("vstruk");
        $strukbuilder->where("id_struk",$id_struk);
        $strukbuilder->where("flag_validasi","2");
        $struk = $strukbuilder->get()->getRow();
        if($struk == null){
            die("Struk Not Available!");
        }

        $data["tanggal"] = $struk->tanggal;
        $data["nomor_transaksi"] = $struk->kode_transaksi;
        $data["nomor_struk"] = $struk->nomor;
        $data['kode_rumah'] = $struk->kode_kk;
        $data['nama_pemilik'] = $struk->nama_pemilik;
        $data['alamat'] = $struk->jalan.', Blok '.$struk->blok.', No. '.$struk->nomor_rumah;
        $data['nominal'] = $struk->total_akhir;
        $data['operator'] = $struk->nama_operator;
        $data['kolektor'] = $struk->nama_kolektor;
        $data['jenis_pembayaran'] = $struk->jenis_pembayaran;
        $data['tanggal_pembayaran'] = $struk->tanggal_pembayaran;
        $data['receiver'] = $struk->pembayar;
        $data['no_telp'] = $struk->no_telp;

        // ===== Data Transaksi ===== //
        $qr_text = base_url().'vwarga/struk/'.$struk->id_struk;

        // ===== Buat QR Code ===== //
        $writer = new PngWriter();
        $qrCode = new QrCode(
            data: $qr_text,
            encoding: new Encoding('UTF-8'),
            errorCorrectionLevel: ErrorCorrectionLevel::Low,
            size: 100,
            margin: 0,
            roundBlockSizeMode: RoundBlockSizeMode::Margin,
            foregroundColor: new Color(0, 0, 0),
            backgroundColor: new Color(255, 255, 255)
        );

        $result = $writer->write($qrCode);

        ob_start();
        $result->saveToFile('php://output');
        $imageData = ob_get_clean();
        $base64 = base64_encode($imageData);
        $imgSrc = 'data:image/png;base64,' . $base64;

        $data['qr_code'] = $imgSrc;

        $periode = array();
        $invoice = array();

        $strukdetailmodel = new Strukdetailmodel();
        $strukdetailbuilder = $strukdetailmodel->builder("vstrukdetail");
        $strukdetail = $strukdetailbuilder->where("id_struk",$id_struk)->get()->getResultArray();
        foreach($strukdetail as $item){
            $periode[] = $item['bulan'].'-'.$item['tahun'];
            $invoice[] = $item["nomor_invoice"];
        }
        $data["periode"] = implode(", ",$periode);
        $data["nomor_invoice"] = implode(", ",$invoice);

        $html = view('print/struk', $data);

        while (ob_get_level()) {
            ob_end_clean();
        }
        $dompdf = new \Dompdf\Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper([0, 0, 612, 312], 'portrait'); // 1/3 folio
        $dompdf->render();
        $dompdf->stream('struk_pembayaran.pdf', ['Attachment' => false]);
    }
}
?>