<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\GeneralLib;

class Diskonmodel extends Model
{
    protected $table         = 'diskon';
    protected $primaryKey = 'id_diskon';
    protected $useAutoIncrement = true;
    protected $useSoftDeletes = true;

    protected $allowedFields = [
        'id_kk', 'nominal', 'start_date', 'end_date', 'keterangan', 'created_by', 'updated_by', 'deleted_by'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function GetDT($request,$extra)
    {
        $genlib = new GeneralLib();
        $db = db_connect();
        //$builder = $db->table('vpangkalan');
        
        $return_data = array();
        $return_data['draw'] = $request['draw'];

        $where = array();
        foreach($request['columns'] as $item){
            if (($item['searchable']=='true') && (!empty($item['search']['value'])))
            {
                $where[] = $item['data']." like '%".$item['search']['value']."%'";
            }
        }

        if (!empty($request['search']['value']))
        {
            $where = array();
            foreach($request['columns'] as $item){
                if (($item['searchable']=='true'))
                {
                    $where[] = $item['data']." like '%".$request['search']['value']."%'";
                }
            }
        }

        if(isset($request['searchBuilder']))
        {
            $filter = $genlib->dt_traverse_search_builder($request['searchBuilder']);
            //die(var_dump($filter));
        }else{
            $filter = implode(" or ",$where);
        }
        //die(var_dump($filter));

        if(isset($request['order'][0]['column'])){
            $order_by = $request['columns'][$request['order'][0]['column']]['data'];
            $order = $request['order'][0]['dir'];
        }else{
            foreach($request['columns'] as $item){
                if($item['orderable']=='true'){
                    $order_by = $item['data'];
                }
            }
            $order = "asc";
        }
        
        $squery = "select * from vdiskon";

        $squery_total = "SELECT
                    count(vdiskon.id_diskon) as jumlah
                    FROM
                    vdiskon";

        $squery_total_filtered = "SELECT
                    count(vdiskon.id_diskon) as jumlah
                    FROM
                    vdiskon";

        if (!empty($filter))
        {
            $filter = "(".$filter.")";
        }

        if (!empty($extra)){
            $squery_total .= " where ".$extra;
            if (empty($filter)){
                $filter = $extra;
            }else{
                $filter .= " and (".$extra.")";
            }
        }
        
        if (!empty($order_by))
        {
            $order_by = " order by ".$order_by." ".$order;
        }
        
        $limit = "";
        if ($request['length'] != "-1"){
            $limit = " limit ".$request['start'].",".$request['length'];
        }
        if (!empty($filter))
        {
            $filter .= " and deleted_at is null ";
            //$data = $builder->where($filter)->orderBy($order_by, $order)->limit($request['start'],$request['length'])->get()->getResult();
            $squery .= " where ".$filter.$order_by.$limit;
            $squery_total_filtered .= " where ".$filter;
        }else{
            //$data = $builder->orderBy($order_by, $order)->limit($request['start'],$request['length'])->get()->getResult();
            $squery .= " where deleted_at is null ".$order_by.$limit;
        }
        //die(var_dump($squery));
        //die(var_dump($registrasi));
        $query_total = $db->query($squery_total);
        $query_total_filtered = $db->query($squery_total_filtered);
        $query = $db->query($squery);

        $row_total = $query_total->getRow();
        $row_total_filtered = $query_total_filtered->getRow();
        $data = $query->getResult();

        $return_data['recordsTotal'] = $row_total->jumlah;
        $return_data['recordsFiltered'] =  $row_total_filtered->jumlah;
        $return_data['data'] = $data;

        return json_encode($return_data);
    }

    public function GetDTKK($request,$extra)
    {
        $genlib = new GeneralLib();
        $db = db_connect();
        //$builder = $db->table('vpangkalan');
        
        $return_data = array();
        $return_data['draw'] = $request['draw'];

        $where = array();
        foreach($request['columns'] as $item){
            if (($item['searchable']=='true') && (!empty($item['search']['value'])))
            {
                $where[] = $item['data']." like '%".$item['search']['value']."%'";
            }
        }

        if (!empty($request['search']['value']))
        {
            $where = array();
            foreach($request['columns'] as $item){
                if (($item['searchable']=='true'))
                {
                    $where[] = $item['data']." like '%".$request['search']['value']."%'";
                }
            }
        }

        if(isset($request['searchBuilder']))
        {
            $filter = $genlib->dt_traverse_search_builder($request['searchBuilder']);
            //die(var_dump($filter));
        }else{
            $filter = implode(" or ",$where);
        }
        //die(var_dump($filter));

        if(isset($request['order'][0]['column'])){
            $order_by = $request['columns'][$request['order'][0]['column']]['data'];
            $order = $request['order'][0]['dir'];
        }else{
            foreach($request['columns'] as $item){
                if($item['orderable']=='true'){
                    $order_by = $item['data'];
                }
            }
            $order = "asc";
        }
        
        $squery = "select * from vkk_diskon";

        $squery_total = "SELECT
                    count(vkk_diskon.id_kk) as jumlah
                    FROM
                    vkk_diskon";

        $squery_total_filtered = "SELECT
                    count(vkk_diskon.id_kk) as jumlah
                    FROM
                    vkk_diskon";

        if (!empty($filter))
        {
            $filter = "(".$filter.")";
        }

        if (!empty($extra)){
            $squery_total .= " where ".$extra;
            if (empty($filter)){
                $filter = $extra;
            }else{
                $filter .= " and (".$extra.")";
            }
        }
        
        if (!empty($order_by))
        {
            $order_by = " order by ".$order_by." ".$order;
        }
        
        if (!empty($filter))
        {
            $filter .= " and deleted_at is null ";
            //$data = $builder->where($filter)->orderBy($order_by, $order)->limit($request['start'],$request['length'])->get()->getResult();
            $squery .= " where ".$filter.$order_by." limit ".$request['start'].",".$request['length'];
            $squery_total_filtered .= " where ".$filter;
        }else{
            //$data = $builder->orderBy($order_by, $order)->limit($request['start'],$request['length'])->get()->getResult();
            $squery .= " where deleted_at is null ".$order_by." limit ".$request['start'].",".$request['length'];
        }
        //die(var_dump($squery));
        //die(var_dump($registrasi));
        $query_total = $db->query($squery_total);
        $query_total_filtered = $db->query($squery_total_filtered);
        $query = $db->query($squery);

        $row_total = $query_total->getRow();
        $row_total_filtered = $query_total_filtered->getRow();
        $data = $query->getResult();

        $return_data['recordsTotal'] = $row_total->jumlah;
        $return_data['recordsFiltered'] =  $row_total_filtered->jumlah;
        $return_data['data'] = $data;

        return json_encode($return_data);
    }

    function getDiskonKK($id_kk){
         $db = db_connect();
         $builder = $db->table('diskon');
         $builder->where("id_kk",$id_kk);
         $builder->where("end_date","9999-12-31");
         $builder->where("deleted_at is null");
         $diskon = $builder->get()->getRow();
         if($diskon == null){
            return 0;
         }else{
            return $diskon->nominal;
         }
    }
}