<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Libraries\GeneralLib;

class Invoicemodel extends Model
{
    protected $table         = 'invoice';
    protected $primaryKey = 'id_invoice';
    protected $useAutoIncrement = true;
    protected $useSoftDeletes = false;

    protected $allowedFields = [
        'id_grup_transaksi', 'id_transaksi', 'id_tarif', 'id_diskon', 'id_kk', 'id_operator', 'nomor', 'tgl_bayar', 'bulan', 'tahun', 'nominal', 'nominal_diskon', 'nominal_akhir', 'jenis_pembayaran', 'dokumen', 'flag_validasi', 'tgl_validasi', 'nomor_struk', 'flag_close', 'created_by', 'updated_by', 'deleted_by'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function GetDTOpen($request,$extra)
    {
        $genlib = new GeneralLib();
        $db = db_connect();
        //$builder = $db->table('vpangkalan');
        
        $return_data = array();
        $return_data['draw'] = $request['draw'];

        $where = array();
        foreach($request['columns'] as $item){
            if (($item['searchable']=='true') && (!empty($item['search']['value'])))
            {
                $where[] = $item['data']." like '%".$item['search']['value']."%'";
            }
        }

        if (!empty($request['search']['value']))
        {
            $where = array();
            foreach($request['columns'] as $item){
                if (($item['searchable']=='true'))
                {
                    $where[] = $item['data']." like '%".$request['search']['value']."%'";
                }
            }
        }

        if(isset($request['searchBuilder']))
        {
            $filter = $genlib->dt_traverse_search_builder($request['searchBuilder']);
            //die(var_dump($filter));
        }else{
            $filter = implode(" or ",$where);
        }
        //die(var_dump($filter));

        if(isset($request['order'][0]['column'])){
            $order_by = $request['columns'][$request['order'][0]['column']]['data'];
            $order = $request['order'][0]['dir'];
        }else{
            foreach($request['columns'] as $item){
                if($item['orderable']=='true'){
                    $order_by = $item['data'];
                }
            }
            $order = "asc";
        }
        
        $squery = "select * from vinvoiceopen";

        $squery_total = "SELECT
                    count(vinvoiceopen.id_invoice) as jumlah
                    FROM
                    vinvoiceopen";

        $squery_total_filtered = "SELECT
                    count(vinvoiceopen.id_invoice) as jumlah
                    FROM
                    vinvoiceopen";

        if (!empty($filter))
        {
            $filter = "(".$filter.")";
        }

        if (!empty($extra)){
            $squery_total .= " where ".$extra;
            if (empty($filter)){
                $filter = $extra;
            }else{
                $filter .= " and (".$extra.")";
            }
        }
        
        if (!empty($order_by))
        {
            $order_by = " order by ".$order_by." ".$order;
        }
        
        $limit = "";
        if ($request['length'] != "-1"){
            $limit = " limit ".$request['start'].",".$request['length'];
        }
        if (!empty($filter))
        {
            $filter .= " and deleted_at is null ";
            //$data = $builder->where($filter)->orderBy($order_by, $order)->limit($request['start'],$request['length'])->get()->getResult();
            $squery .= " where ".$filter.$order_by.$limit;
            $squery_total_filtered .= " where ".$filter;
        }else{
            //$data = $builder->orderBy($order_by, $order)->limit($request['start'],$request['length'])->get()->getResult();
            $squery .= " where deleted_at is null ".$order_by.$limit;
        }
        //die(var_dump($squery));
        //die(var_dump($registrasi));
        $query_total = $db->query($squery_total);
        $query_total_filtered = $db->query($squery_total_filtered);
        $query = $db->query($squery);

        $row_total = $query_total->getRow();
        $row_total_filtered = $query_total_filtered->getRow();
        $data = $query->getResult();

        $return_data['recordsTotal'] = $row_total->jumlah;
        $return_data['recordsFiltered'] =  $row_total_filtered->jumlah;
        $return_data['data'] = $data;

        return json_encode($return_data);
    }

    public function GetDTClose($request,$extra)
    {
        $genlib = new GeneralLib();
        $db = db_connect();
        //$builder = $db->table('vpangkalan');
        
        $return_data = array();
        $return_data['draw'] = $request['draw'];

        $where = array();
        foreach($request['columns'] as $item){
            if (($item['searchable']=='true') && (!empty($item['search']['value'])))
            {
                $where[] = $item['data']." like '%".$item['search']['value']."%'";
            }
        }

        if (!empty($request['search']['value']))
        {
            $where = array();
            foreach($request['columns'] as $item){
                if (($item['searchable']=='true'))
                {
                    $where[] = $item['data']." like '%".$request['search']['value']."%'";
                }
            }
        }

        if(isset($request['searchBuilder']))
        {
            $filter = $genlib->dt_traverse_search_builder($request['searchBuilder']);
            //die(var_dump($filter));
        }else{
            $filter = implode(" or ",$where);
        }
        //die(var_dump($filter));

        $order_by = $request['columns'][$request['order'][0]['column']]['data'];
        $order = $request['order'][0]['dir'];
        
        $squery = "select * from vinvoiceclosed";

        $squery_total = "SELECT
                    count(vinvoiceclosed.id_invoice) as jumlah
                    FROM
                    vinvoiceclosed";

        $squery_total_filtered = "SELECT
                    count(vinvoiceclosed.id_invoice) as jumlah
                    FROM
                    vinvoiceclosed";

        if (!empty($filter))
        {
            $filter = "(".$filter.")";
        }

        if (!empty($extra)){
            $squery_total .= " where ".$extra;
            if (empty($filter)){
                $filter = $extra;
            }else{
                $filter .= " and (".$extra.")";
            }
        }
        
        if (!empty($order_by))
        {
            $order_by = " order by ".$order_by." ".$order;
        }
        
        $limit = "";
        if ($request['length'] != "-1"){
            $limit = " limit ".$request['start'].",".$request['length'];
        }
        if (!empty($filter))
        {
            $filter .= " and deleted_at is null ";
            //$data = $builder->where($filter)->orderBy($order_by, $order)->limit($request['start'],$request['length'])->get()->getResult();
            $squery .= " where ".$filter.$order_by.$limit;
            $squery_total_filtered .= " where ".$filter;
        }else{
            //$data = $builder->orderBy($order_by, $order)->limit($request['start'],$request['length'])->get()->getResult();
            $squery .= " where deleted_at is null ".$order_by.$limit;
        }
        //die(var_dump($squery));
        //die(var_dump($registrasi));
        $query_total = $db->query($squery_total);
        $query_total_filtered = $db->query($squery_total_filtered);
        $query = $db->query($squery);

        $row_total = $query_total->getRow();
        $row_total_filtered = $query_total_filtered->getRow();
        $data = $query->getResult();

        $return_data['recordsTotal'] = $row_total->jumlah;
        $return_data['recordsFiltered'] =  $row_total_filtered->jumlah;
        $return_data['data'] = $data;

        return json_encode($return_data);
    }

    public function getNewKode($tahunbulan){
        $db = \Config\Database::connect();
        $builder = $db->table('invoice_counter');
        $db->transStart();
        $yearMonth = $tahunbulan;
        $row = $builder
                ->where('tahunbulan', $yearMonth)
                ->getWhere([], 1, 0, true) // true = gunakan SQL_CALC_FOUND_ROWS
                ->getRow();
        if ($row) {
            $newNumber = $row->urutan + 1;

            $builder->where('tahunbulan', $yearMonth)
                    ->update(['urutan' => $newNumber]);
        } else {
            $newNumber = 1;
            $builder->insert([
                'tahunbulan' => $yearMonth,
                'urutan' => $newNumber
            ]);
        }

        $db->transComplete(); // Commit atau Rollback

        if ($db->transStatus() === false) {
            return "";
        }
        $db->transCommit();

        return 'INV/IKK/'.$yearMonth.'/'.str_pad($newNumber,5,"0",STR_PAD_LEFT);
    }

    public function getTotalOpen(){
        $db = \Config\Database::connect();
        $builder = $db->table('invoice');
        $builder->where("flag_close","0");
        $hasil = $builder->selectCount("id_invoice","invoice_open")->get()->getRow();
        if (!$hasil){
            return 0;
        }else{
            return $hasil->invoice_open;
        }
    }

    public function getTotalClosed(){
        $db = \Config\Database::connect();
        $builder = $db->table('invoice');
        $builder->where("flag_close","1");
        $hasil = $builder->selectCount("id_invoice","invoice_closed")->get()->getRow();
        if (!$hasil){
            return 0;
        }else{
            return $hasil->invoice_closed;
        }
    }
}