<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Pembayaran Invoice</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>invoice/open">Open Invoice</a></li>
        <li class="breadcrumb-item active" aria-current="page">Pembayaran</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>invoice/open" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-6">
        <form name="f1" id="f1" action="<?=base_url()?>invoice/save_pembayaran" method="post" enctype="multipart/form-data">
            <div class="card card-warning card-outline mb-4">
                <div class="card-header">
                    <div class="card-title">Pembayaran</div>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="grup_pembayaran" class="form-label">Grup Pembayaran</label>
                        <span class="form-control" id="grup_pembayaran"><?=$data->nama_grup_pembayaran?></span>
                    </div>
                    <div class="mb-3">
                        <label for="nomor" class="form-label">Nomor Invoice</label>
                        <span class="form-control" id="nomor"><?=$data->nomor?></span>
                    </div>
                    <div class="mb-3">
                        <label for="periode" class="form-label">Periode</label>
                        <span class="form-control" id="periode"><?=$data->periode?></span>
                    </div>
                    <div class="mb-3">
                        <label for="iuran" class="form-label">Iuran</label>
                        <span class="form-control" id="iuran"><?=number_format($data->biaya,2,",",".")?></span>
                    </div>
                    <hr/>
                    <div class="mb-3">
                        <b>Silahkan Isi Informasi berikut :</b>
                    </div>
                    <div class="mb-3">
                        <label for="pembayar" class="form-label">Nama Pembayar :</label>
                        <input type="text" class="form-control" id="pembayar" name="pembayar">
                        <span id="epembayar" class="text-danger invalid-feedback"></span>
                    </div>
                    <div class="mb-3">
                        <label for="no_telp" class="form-label">Nomor Telepon :</label>
                        <input type="text" class="form-control" id="no_telp" name="no_telp">
                        <span id="eno_telp" class="text-danger invalid-feedback"></span>
                    </div>
                    <div class="mb-3">
                        <label for="jenis_pembayaran" class="form-label">Jenis Pembayaran :</label>
                        <select class="form-control" id="jenis_pembayaran" name="jenis_pembayaran">
                            <option value="Cash">Cash</option>
                            <option value="Transfer">Transfer</option>
                            <option value="QRis">QRis</option>
                        </select>
                    </div>
                </div>
                <div class="card-footer d-flex">
                    <button type="submit" class="btn btn-primary">Bayar</button>
                    <button type="reset" class="btn btn-warning ml-auto">Cancel</button>
                </div>
            </div>
        </form>        
    </div>
    <div class="col-lg-6">
        <div class="card card-warning card-outline mb-4">
            <div class="card-header">
                <div class="card-title">Detail KK</div>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Kode KK</label>
                    <span class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"><?=$data->kode?></span>
                </div>
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Nama Pemilik</label>
                    <span class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"><?=$data->nama_pemilik?></span>
                </div>
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Jalan</label>
                    <span class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"><?=$data->jalan?></span>
                </div>
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Blok</label>
                    <span class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"><?=$data->blok?></span>
                </div>
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Nomor Rumah</label>
                    <span class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"><?=$data->nomor_rumah?></span>
                </div>
            </div>
            <div class="card-footer d-flex">
                
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<script type="text/javascript">
$(document).ready(function() {

$("#f1").submit(function (e) {
    e.preventDefault();
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();

    var data_kirim = $("#f1").serializeArray();
    data_kirim.push({name : "id_invoice", value : "<?=$data->id_invoice?>"});

    $.post("<?=base_url()?>invoice/save_pembayaran",data_kirim).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Invoice berhasil di-update!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>invoice/view_closed/<?=$data->id_invoice?>';
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});
});
</script>
<?= $this->endSection() ?>