<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Jalan dan Blok</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>jalan">Jalan dan Blok</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>jalan/view/<?=$jalan->id_jalan?>"><?=$jalan->nama?></a></li>
        <li class="breadcrumb-item active" aria-current="page">Add Blok</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>jalan/view/<?=$jalan->id_jalan?>" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-8">
        <form name="f1" id="f1" action="<?=base_url()?>jalan/save_add" method="post" enctype="multipart/form-data">
            <div class="card card-warning card-outline mb-4">
                <div class="card-header">
                    <div class="card-title">Add New Blok</div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <label for="nama" class="col-sm-2 col-form-label">Jalan : </label>
                        <div class="col-sm-10">
                            <span class="form-control bg-secondary text-white">[<?=$jalan->kode?>] <?=$jalan->nama?></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="kode" class="col-sm-2 col-form-label">Kode : </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" id="kode" name="kode">
                            <span id="ekode" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="nama" class="col-sm-2 col-form-label">Nama Blok : </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" id="nama" name="nama">
                            <span id="enama" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="keterangan" class="col-sm-2 col-form-label">Keterangan : </label>
                        <div class="col-sm-10">
                            <textarea class="form-control" id="keterangan" name="keterangan"></textarea>
                            <span id="enama" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-warning ml-auto">Cancel</button>
                </div>
            </div>
        </form>        
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>
<script type="text/javascript">
$(document).ready(function() {

$("#f1").submit(function (e) {
    e.preventDefault();
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    var data_kirim = $("#f1").serializeArray();
    data_kirim.push({name : "id_jalan", value : "<?=$jalan->id_jalan?>"});

    $.post("<?=base_url()?>jalan/add_save_blok",data_kirim).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Data baru berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>jalan/view/<?=$jalan->id_jalan?>';
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});

});
</script>
<?= $this->endSection() ?>