<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">KK</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>kk">KK</a></li>
        <li class="breadcrumb-item active" aria-current="page">Add</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>kk" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-8">
        <form name="f1" id="f1" action="<?=base_url()?>kk/save_add" method="post" enctype="multipart/form-data">
            <div class="card card-warning card-outline mb-4">
                <div class="card-header">
                    <div class="card-title">Add New</div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <label for="kode" class="col-sm-3 col-form-label">Kode : </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="kode" name="kode">
                            <span id="ekode" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="id_jenis_kk" class="col-sm-3 col-form-label">Jenis KK : </label>
                        <div class="col-sm-9 d-flex align-items-center">
                            <span class="form-control" id="id_jenis_kk" class="text-secondary">- Pilih Jenis KK -</span>
                            <a id="b_cari_jenis_kk" href="#" class="btn btn-primary">Pilih</a>
                            <input type="hidden" name="id_jenis_kk">
                            <span id="eid_jenis_kk" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="nama" class="col-sm-3 col-form-label">Nama Pemilik : </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="nama_pemilik" name="nama_pemilik">
                            <span id="enama_pemilik" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="blok" class="col-sm-3 col-form-label">Jalan : </label>
                        <div class="col-sm-9 d-flex align-items-center">
                            <input type="text" class="form-control" id="jalan" name="jalan">
                            <span id="ejalan" class="text-danger invalid-feedback"></span>
                            <!-- <span id="id_jalan" class="form-control">- Pilih Jalan dan Blok -</span>
                            <a id="b_cari_jalanblok" href="#" class="btn btn-primary">Pilih</a> -->
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="blok" class="col-sm-3 col-form-label">Blok : </label>
                        <div class="col-sm-9">
                            <!-- <span id="id_blok" class="form-control">-</span>
                            <input type="hidden" class="form-control" name="id_blok"> -->
                            <input type="text" class="form-control" id="blok" name="blok">
                            <span id="eblok" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="nomor_rumah" class="col-sm-3 col-form-label">Nomor Rumah : </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="nomor_rumah" name="nomor_rumah">
                            <span id="enomor_rumah" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="area" class="col-sm-3 col-form-label">Area : </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="area" name="area">
                            <span id="earea" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="keterangan" class="col-sm-3 col-form-label">Keterangan : </label>
                        <div class="col-sm-9">
                            <textarea class="form-control" id="keterangan" name="keterangan"></textarea>
                            <span id="eketerangan" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-warning ml-auto">Cancel</button>
                </div>
            </div>
        </form>        
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>
<?= $this->include('layout/css/select2') ?>
<?= $this->include('layout/js/select2') ?>
<?= $this->include('layout/js/jquerymask') ?>

<?= $this->include('layout/css/draggable_dialog') ?>
<?= $this->include('layout/js/draggable_dialog') ?>

<?= $this->include('layout/js/datatables') ?>

<div id="dialogJenisKK" class="dialog" style="min-width:500px; min-height:400px;">
	<div class="titlebar"></div>
	<button name="close"></button>
	<div class="content">
        <table id="tbl_dialog_jenis_kk" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Nama</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
	</div>
	<div class="buttonpane">
		<div class="buttonset">
			<button name="cancel">Cancel</button>
		</div>
	</div>
</div>

<div id="dialogJalanBlok" class="dialog" style="min-width:600px; min-height:400px;">
    <button name="close"></button>
    <div class="titlebar"></div>
    <div class="content">
        <table id="tbl_dialog_jalanblok" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Kode Jalan</th>
                    <th class="dt-filterable">Nama Jalan</th>
                    <th class="dt-filterable">Kode Blok</th>
                    <th class="dt-filterable">Nama Blok</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
    <div class="buttonpane">
        <div class="buttonset">
            <button name="cancel">Cancel</button>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {

$("#f1").submit(function (e) {
    e.preventDefault();
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    
    var data_kirim = $("#f1").serialize();

    $.post("<?=base_url()?>kk/add_save",data_kirim).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'KK baru berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>kk/add';
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});

});
</script>

<script>
var dialogJenisKK;
var dialogJalanBlok;
var tbl_dialog_jenis_kk;
var tbl_dialog_jalanblok;

function setDialogForInput(dialog, dialog_id, button, table_dialog, table_dialog_id, ajax_url, input, display){
    function showDialog() {
        if (!dialog) {
            dialog = new DialogBox(dialog_id, callbackDialog);
        }
        // Show Dialog Box
        dialog.showDialog();
        function callbackDialog(btnName) {
        }
    }

    $("#" + button).click(function(e){
        e.preventDefault();
        showDialog();
    });

    table_dialog = $("#" + table_dialog_id).DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        pageLength:10,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'frtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>' + ajax_url,
            type : 'POST'
        },
        columns: [
            { data: null,
                    width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'nama' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 2,
                data: null,
                defaultContent: '<a href="#" class="btn-pilih btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> Pilih</a>',
            },
        ],
        "initComplete": function(settings, json) {
        }
    });

    table_dialog.on( 'draw.dt', function () {
        var PageInfo = $('#' + table_dialog_id).DataTable().page.info();
        table_dialog.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#' + table_dialog_id + ' tbody').on('click','.btn-pilih',function (e) {
        e.preventDefault();
        var data = table_dialog.row($(this).parents('tr')[0]).data();
        $("#" + display).html(data['nama']);
        $("input[name='" + input + "']").val(data[display]);
        dialog.close();
    });
}

function setDialogForInput2(dialog, dialog_id, button, table_dialog, table_dialog_id, ajax_url, input, display){
    function showDialog() {
        if (!dialog) {
            dialog = new DialogBox(dialog_id, callbackDialog);
        }
        // Show Dialog Box
        dialog.showDialog();
        function callbackDialog(btnName) {
        }
    }

    $("#" + button).click(function(e){
        e.preventDefault();
        showDialog();
    });

    table_dialog = $("#" + table_dialog_id).DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        pageLength:10,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'frtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>' + ajax_url,
            type : 'POST'
        },
        columns: [
            { data: null,
                    width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'kode_jalan' },
            { data: 'nama_jalan' },
            { data: 'kode' },
            { data: 'nama' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 5,
                data: null,
                defaultContent: '<a href="#" class="btn-pilih btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> Pilih</a>',
            },
        ],
        "initComplete": function(settings, json) {
        }
    });

    table_dialog.on( 'draw.dt', function () {
        var PageInfo = $('#' + table_dialog_id).DataTable().page.info();
        table_dialog.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#' + table_dialog_id + ' tbody').on('click','.btn-pilih',function (e) {
        e.preventDefault();
        var data = table_dialog.row($(this).parents('tr')[0]).data();
        $("#id_jalan").html("[" + data['kode_jalan'] + "] " + data['nama_jalan']);
        $("#" + display).html("[" + data['kode'] + "] " + data['nama']);
        $("input[name='" + input + "']").val(data[display]);
        dialog.close();
    });
}

setDialogForInput(dialogJenisKK, 'dialogJenisKK', 'b_cari_jenis_kk', tbl_dialog_jenis_kk, 'tbl_dialog_jenis_kk', 'jenis_kk/ajax_dt', 'id_jenis_kk', 'id_jenis_kk');

setDialogForInput2(dialogJalanBlok, 'dialogJalanBlok', 'b_cari_jalanblok', tbl_dialog_jalanblok, 'tbl_dialog_jalanblok', 'jalan/ajax_dt_blok2', 'id_blok', 'id_blok');
</script>
<?= $this->endSection() ?>