<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row">
    <div class="col-sm-6"><h3 class="mb-0">Laporan Harian</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item active" aria-current="page">Laporan Harian</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body d-flex justify-content-end gap-2">
                <a href="<?=base_url()?>laporan/export_voucher_harian/<?=$tanggal?>" target="_blank" class="btn btn-primary">Export Voucher</a>
                <a href="<?=base_url()?>laporan/export_penerimaan_harian/<?=$tanggal?>" target="_blank" class="btn btn-primary">Export Penerimaan</a>
                <a href="<?=base_url()?>laporan/export_bukti_harian/<?=$tanggal?>" target="_blank" class="btn btn-primary">Export Bukti Bayar</a>
            </div>
        </div>
    </div>
</div>
<div class="row mb-3">
    <div class="col-lg-12">
            <h5>Tanggal : <?=$tanggal?> | <a class="btn btn-success btn-sm" data-bs-toggle="collapse" href="#filter_tanggal" role="button" aria-expanded="false" aria-controls="filter_tanggal">
                Ganti Tanggal
            </a>
        </h5>
        <div class="collapse w-50" id="filter_tanggal">
            <div class="card card-body">
                <div class="row form-group">
                    <div class="col-3 col-form-label">Tanggal :</div>
                    <div class="col-5"><input type="date" id="set_tanggal" name="set_tanggal" class="form-control"></div>
                    <div class="col-4"><button id="b_set_tanggal" class="btn btn-sm btn-primary">Set Tanggal</button></div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row mb-2">
    <div class="col-lg-3">
        <div class="info-box">
            <div class="info-box-content">
                <span class="info-box-text">Trans Pending</span>
                <span class="info-box-number"><?=($trans_draft + $trans_pending)?></span>
            </div>
        </div>
    </div>
    <div class="col-lg-3">
        <div class="info-box">
            <div class="info-box-content">
                <span class="info-box-text">Trans Completed</span>
                <span class="info-box-number"><?=($trans_completed)?></span>
            </div>
        </div>
    </div>
    <div class="col-lg-3">
        <div class="info-box">
            <div class="info-box-content">
                <span class="info-box-text">Trans Canceled</span>
                <span class="info-box-number"><?=($trans_canceled)?></span>
            </div>
        </div>
    </div>
    <div class="col-lg-3">
        <div class="info-box">
            <div class="info-box-content">
                <span class="info-box-text">Trans Total</span>
                <span class="info-box-number"><?=($trans_total)?></span>
            </div>
        </div>
    </div>
</div>

<div class="row mb-3">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-body">
                <h5>Jenis Pembayaran</h5>
                <span class="text-muted">Jumlah berdasarkan jenis pembayaran transaksi</span>
                <table class="table mt-5">
                    <tr>
                        <td>Cash</td>
                        <td class="text-end">Rp. <?=number_format($jenis_pembayaran['cash'],0,',','.')?></td>
                    </tr>
                    <tr>
                        <td>Transfer</td>
                        <td class="text-end">Rp. <?=number_format($jenis_pembayaran['transfer'],0,',','.')?></td>
                    </tr>
                    <tr>
                        <td><b>Total</b></td>
                        <td class="text-end"><b>Rp. <?=number_format($total_jenis_pembayaran,0,',','.')?></b></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-body">
                <h5>Grup Pembayaran</h5>
                <span class="text-muted">Jumlah berdasarkan grup transaksi</span>
                <table class="table mt-5">
                    <?php foreach($gruptransaksi as $item): ?>
                    <tr>
                        <td><?=$item['nama']?></td>
                        <td class="text-end">Rp. <?=number_format($item['total'],0,',','.')?></td>
                    </tr>
                    <?php endforeach; ?>
                    <tr>
                        <td><b>Total</b></td>
                        <td class="text-end"><b>Rp. <?=number_format($gruptransaksi_total,0,',','.')?></b></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-12">
        <table id="tbl1" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Kode</th>
                    <th class="dt-filterable">Grup</th>
                    <th class="dt-filterable">Tanggal</th>
                    <th class="dt-filterable">Total Awal</th>
                    <th class="dt-filterable">Diskon</th>
                    <th class="dt-filterable">Total Akhir</th>
                    <th class="dt-filterable">Jenis Pembayaran</th>
                    <th class="dt-filterable">Tgl. Pembayaran</th>
                    <th class="dt-filterable">Pembayar</th>
                    <th class="dt-filterable">No. Telp</th>
                    <th class="dt-filterable">Operator</th>
                    <th class="dt-filterable">Kolektor</th>
                    <th class="dt-filterable">Batal</th>
                    <th class="dt-filterable">Status</th>
                    <th class="dt-filterable">Tgl Status</th>
                    <th class="dt-filterable">Keterangan</th>
                    <th class="dt-filterable">Created At</th>
                    <th class="dt-filterable">Updated At</th>
                    <th class="dt-filterable">Updater</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/js/datatables') ?>

<script type="text/javascript">
$(document).ready(function () {
    var table1 = $("#tbl1").DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        lengthMenu: [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
        pageLength:50,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'Bfrtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>laporan/ajax_dt_trans_harian/<?=$tanggal?>',
            type : 'POST'
        },
        columns: [
            { data: null,
                 width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'kode' },
            { data: 'nama_grup_transaksi' },
            { data: 'tanggal' },
            { data: 'total', render: DataTable.render.number(",",".",2) },
            { data: 'total_diskon', render: DataTable.render.number(",",".",2) },
            { data: 'total_akhir', render: DataTable.render.number(",",".",2) },
            { data: 'jenis_pembayaran' },
            { data: 'tanggal_pembayaran' },
            { data: 'pembayar' },
            { data: 'no_telp' },
            { data: 'nama_operator' },
            { data: 'nama_kolektor' },
            { data: 'status_batal' },
            { data: 'status_validasi' },
            { data: 'tanggal_validasi' },
            { data: 'keterangan_validasi' },
            { data: 'created_at' },
            { data: 'updated_at' },
            { data: 'updated_username' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 20,
                data: null,
                defaultContent: '<button class="btn-view btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> View</button>',
            },
        ],
        buttons: [
            'pageLength',
            'searchBuilder',
            'copyHtml5',
            {
                extend: 'excelHtml5',
                text: 'Export Excel',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'csvHtml5',
                text: 'Export CSV',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            }
        ],
        "initComplete": function(settings, json) {
        }
    });

    table1.on( 'draw.dt', function () {
        var PageInfo = $('#tbl1').DataTable().page.info();
        table1.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#tbl1 tbody').on('click','.btn-view',function () {
        var data = table1.row($(this).parents('tr')[0]).data();
        document.location.href='<?=base_url()?>transaksi/view/'+data['id_transaksi'];
    });

    $("#b_set_tanggal").click(function() {
        var tanggal = $("#set_tanggal").val();
        if(tanggal){
           document.location.href="<?=base_url()?>laporan/harian/" + tanggal; 
        }
    });
});
</script>
<?= $this->endSection() ?>