<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Transaksi</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>transaksi">Transaksi Pembayaran</a></li>
        <li class="breadcrumb-item active" aria-current="page">View</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>transaksi" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-8">
        <form name="f1" id="f1" action="<?=base_url()?>transaksi/update" method="post" enctype="multipart/form-data">
            <div class="card card-warning card-outline mb-4">
                <div class="card-header">
                    <div class="card-title">Header Transaksi</div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <label for="kode" class="col-sm-3 col-form-label">Kode : </label>
                        <div class="col-sm-9 d-flex align-items-center">
                            <span class="form-control" id="kode" class="text-secondary"><?=$transaksi->kode?></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="id_grup_transaksi" class="col-sm-3 col-form-label">Grup Transaksi : </label>
                        <div class="col-sm-9 d-flex align-items-center">
                            <span class="form-control" id="id_grup_transaksi" class="text-secondary"><?=$transaksi->nama_grup_transaksi?></span>
                            <a id="b_cari_grup_transaksi" href="#" class="btn btn-primary">Pilih</a>
                            <input type="hidden" name="id_grup_transaksi" value="<?=$transaksi->id_grup_transaksi?>">
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="id_kolektor" class="col-sm-3 col-form-label">Kolektor : </label>
                        <div class="col-sm-9 d-flex align-items-center">
                            <span class="form-control" id="id_kolektor" class="text-secondary">[<?=$transaksi->kode_kolektor?>] <?=$transaksi->nama_kolektor?></span>
                            <a id="b_cari_kolektor" href="#" class="btn btn-primary">Pilih</a>
                            <input type="hidden" name="id_kolektor" value="<?=$transaksi->id_kolektor?>">
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="id_operator" class="col-sm-3 col-form-label">Operator : </label>
                        <div class="col-sm-9 d-flex align-items-center">
                            <span class="form-control" id="id_operator" class="text-secondary"><?=$transaksi->nama_operator?></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="status" class="col-sm-3 col-form-label">Status : </label>
                        <div class="col-sm-9 d-flex align-items-center">
                            <span class="form-control" id="status" class="text-secondary"><?=$transaksi->status_validasi?></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="tanggal" class="col-sm-3 col-form-label">Tanggal : </label>
                        <div class="col-sm-9">
                            <input type="date" class="form-control" id="tanggal" name="tanggal" value="<?=$transaksi->tanggal?>">
                            <span id="etanggal" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex">
                    <?php
                    if(($transaksi->flag_batal=='0') && ($transaksi->flag_validasi<=1)):
                    ?>
                    <button type="submit" class="btn btn-primary">Update</button>
                    <?php
                    endif;
                    ?>
                </div>
            </div>
        </form>        
    </div>
</div>

<div class="row mb-4">
    <div class="col-lg-12">
        <div class="card card-warning card-outline">
            <div class="card-header">
                <div class="card-title d-flex justify-content-between w-100">
                    <div>Detail Transaksi</div>
                    <div class="d-flex justify-content-between gap-3"><div><a href="#" id="b_cari_rumah" class="btn btn-sm btn-primary btn-icon"> <span>Tambah Pembayaran</span></a></div>
                    <div><a href="#" id="b_cari_rumah_simple" class="btn btn-sm btn-primary btn-icon"> <span>Tambah Pembayaran Simple</span></a></div></div>
                </div>
            </div>
            <div class="card-body p-0">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Kode</th>
                            <th>Alamat</th>
                            <th>Periode</th>
                            <th>Sub Total</th>
                            <th>Diskon</th>
                            <th>Total</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no=1;
                        foreach($detail_transaksi as $item):
                        ?>
                        <tr>
                            <td><?=$no?></td>
                            <td><?=$item['kode_kk']?></td>
                            <td><?=$item['alamat']?></td>
                            <td><?=$item['periode']?></td>
                            <td>Rp. <?=number_format($item['total'],0,",",".")?></td>
                            <td>Rp. <?=number_format($item['total_diskon'],0,",",".")?></td>
                            <td>Rp. <?=number_format($item['total_akhir'],0,",",".")?></td>
                            <td><a href="<?=base_url()?>transaksi/add_detail/<?=$transaksi->id_transaksi?>/<?=$item["id_kk"]?>" class="btn btn-sm btn-success">Detail</a>
                            <?php
                            if(($transaksi->flag_batal == '0') && ($transaksi->flag_validasi <= 1)) :
                            ?>
                            | <a href="<?=base_url()?>transaksi/cancel_detail/<?=$transaksi->id_transaksi?>/<?=$item["id_kk"]?>" class="btn btn-sm btn-danger">Cancel</a></td>
                            <?php
                            endif;
                            ?>
                        </tr>
                        <?php
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Rekap</div>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <tbody>
                        <tr>
                            <td>Diskon :</td>
                            <td>Rp. <?=number_format($total_diskon,2,".",",")?></td>
                        </tr>
                        <tr>
                            <td>Total :</td>
                            <td>Rp. <?=number_format($total_akhir,2,".",",")?></td>
                        </tr>
                        <tr>
                            <td>Status Batal :</td>
                            <td><?=$transaksi->status_batal?></td>
                        </tr>
                        <tr>
                            <td>Status Validasi :</td>
                            <td><?=$transaksi->status_validasi?></td>
                        </tr>
                        <tr>
                            <td>Tanggal Validasi :</td>
                            <td><?=$transaksi->tanggal_validasi?></td>
                        </tr>
                        <tr>
                            <td>Keterangan :</td>
                            <td><textarea id="keterangan" class="form-control"><?=$transaksi->keterangan_validasi?></textarea></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Pembayaran</div>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <tbody>
                        <tr>
                            <td>Jenis Pembayaran :</td>
                            <td>
                                <select class="form-control" name="id_jenis_pembayaran" id="id_jenis_pembayaran">
                                    <?php foreach($jenis_pembayaran as $item) : ?>
                                    <option value="<?=$item['id_jenis_pembayaran']?>" <?=($transaksi->jenis_pembayaran==$item['nama']) ? "selected" : ""?>><?=$item['nama']?></option>
                                    <?php endforeach; ?>
                                </select>
                                <span id="eid_jenis_pembayaran" class="text-danger invalid-feedback"></span>
                            </td>
                        </tr>
                        <tr>
                            <td>Tanggal Pembayaran :</td>
                            <td><input class="form-control" type="date" name="tanggal_pembayaran" id="tanggal_pembayaran" value="<?=$transaksi->tanggal_pembayaran?>">
                                <span id="etanggal_pembayaran" class="text-danger invalid-feedback"></span>
                            </td>
                        </tr>
                        <tr>
                            <td>Nama Penerima :</td>
                            <td>
                                <input class="form-control" type="text" name="pembayar" id="pembayar" value="<?=$transaksi->pembayar?>">
                                <span id="epembayar" class="text-danger invalid-feedback"></span>
                            </td>
                        </tr>
                        <tr>
                            <td>No. Telp :</td>
                            <td>
                                <input class="form-control" type="text" name="no_telp" id="no_telp" value="<?=$transaksi->no_telp?>">
                                <span id="eno_telp" class="text-danger invalid-feedback"></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <hr/>
                <table class="table table-stripped">
                    <tbody>
                        <tr>
                            <td colspan="2"><b>Bukti Pembayaran :</b></td>
                        </tr>
                        <?php
                        if(($transaksi->flag_batal=='0') && ($transaksi->flag_validasi<=1)):
                        ?>
                        <tr>
                            <td>Upload File : </td>
                            <td>
                                <!-- <input type="file" id="fileInput" accept="image/*">
                                <a href="#" class="btn btn-success btn-sm" id="uploadBtn">Upload</a>  -->
                                <button class="btn btn-primary btn-sm" id="btn_browse_bukti"><i class="fas fa-file-upload"></i> Upload File</button>
                            </td>
                        </tr>
                        <?php
                        endif;
                        ?>
                        <tr>
                        <td colspan="2">
                            <div id="list_bukti_bayar" class="w-100">
                            <?php
                            foreach($bukti_bayar as $item):
                            ?>
                                <div class="item_bukti_bayar text-center mb-2" id="bukti_<?=$item['id_bukti_bayar']?>">
                                    <div class="mb-2">
                                        <img src="<?=base_url()?>bukti_bayar/<?=$item['fnama']?>">
                                    </div>
                                    <div class="d-flex justify-content-center gap-2">
                                        <a href="<?=base_url()?>transaksi/download_bukti_bayar/<?=$transaksi->id_transaksi?>" class="btn btn-primary btn-sm" target="_blank">Download</a>
                                        <?php
                                        if(($transaksi->flag_batal == '0') && ($transaksi->flag_validasi <= 1)) :
                                        ?>
                                        <a href="#" class="b_delete_bukti btn btn-danger btn-sm" data-id="<?=$item['id_bukti_bayar']?>" class="btn btn-danger btn-sm">Delete</a>
                                        <?php
                                        endif;
                                        ?>
                                    </div>
                                    <hr/>
                                </div>
                            <?php
                            endforeach;
                            ?>
                            </div>
                        </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <?php
                if(($transaksi->flag_batal=='0') && ($transaksi->flag_validasi<=1)):
                ?>
                <button id="b_selesai" class="btn btn-primary">Selesaikan Transaksi</button>
                <?php
                endif;
                ?>

                <?php
                if(($transaksi->flag_batal=='0')):
                ?>
                <button id="b_batal" class="btn btn-danger">Tolak / Batalkan Transaksi</button>
                <?php
                endif;
                ?>

                <?php
                if(($transaksi->flag_validasi=='2')):
                ?>
                <a href="<?=base_url()?>transaksi/multistruk/<?=$transaksi->id_transaksi?>" id="b_cetak" class="btn btn-info" target="_blank">Cetak Kwitansi</a>
                <?php
                endif;
                ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<?= $this->include('layout/css/draggable_dialog') ?>
<?= $this->include('layout/js/draggable_dialog') ?>
<?= $this->include('layout/js/datatables') ?>

<?= $this->include('layout/js/plupload') ?>

<div id="dialogGrupTransaksi" class="dialog" style="min-width:500px; min-height:400px;">
	<div class="titlebar"></div>
	<button name="close"></button>
	<div class="content">
        <table id="tbl_dialog_grup_transaksi" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Nama</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
	</div>
	<div class="buttonpane">
		<div class="buttonset">
			<button name="cancel">Cancel</button>
		</div>
	</div>
</div>

<div id="dialogKolektor" class="dialog" style="min-width:500px; min-height:400px;">
	<div class="titlebar"></div>
	<button name="close"></button>
	<div class="content">
        <table id="tbl_dialog_kolektor" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Kode</th>
                    <th class="dt-filterable">Nama</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
	</div>
	<div class="buttonpane">
		<div class="buttonset">
			<button name="cancel">Cancel</button>
		</div>
	</div>
</div>

<div id="dialogRumah" class="dialog" style="min-width:500px; min-height:400px;">
	<div class="titlebar"></div>
	<button name="close"></button>
	<div class="content">
        <table id="tbl_dialog_rumah" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Kode</th>
                    <th class="dt-filterable">Pemilik</th>
                    <th class="dt-filterable">Alamat</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
	</div>
	<div class="buttonpane">
		<div class="buttonset">
			<button name="cancel">Cancel</button>
		</div>
	</div>
</div>

<div id="dialogRumahSimple" class="dialog" style="min-width:500px; min-height:400px;">
	<div class="titlebar"></div>
	<button name="close"></button>
	<div class="content">
        <table id="tbl_dialog_rumah_simple" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Kode</th>
                    <th class="dt-filterable">Pemilik</th>
                    <th class="dt-filterable">Alamat</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
	</div>
	<div class="buttonpane">
		<div class="buttonset">
			<button name="cancel">Cancel</button>
		</div>
	</div>
</div>

<script type="text/javascript">
$(document).ready(function() {

$("#f1").submit(function (e) {
    e.preventDefault();
    <?php
    if(($transaksi->flag_batal=='0') && ($transaksi->flag_validasi<=1)):
    ?>
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    
    var data_kirim = $("#f1").serializeArray();
    data_kirim.push({name:"id_transaksi",value:"<?=$transaksi->id_transaksi?>"});
    var final_data = $.param(data_kirim);

    $.ajax({
        url : "<?=base_url()?>transaksi/update",
        type:'POST',
        data : final_data
    }).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Transaksi berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>transaksi/view/' + data.id;
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });

    <?php
    endif;
    ?>
});

<?php
if(($transaksi->flag_batal=='0') && ($transaksi->flag_validasi<=1)):
?>

$("#b_selesai").click(function() {
    Swal.fire({
        text: 'Memproses.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();

    var data_kirim = {
            id_transaksi: '<?=$transaksi->id_transaksi?>',
            id_jenis_pembayaran: $('#id_jenis_pembayaran').val(),
            tanggal_pembayaran: $('#tanggal_pembayaran').val(),
            pembayar: $('#pembayar').val(),
            no_telp: $('#no_telp').val(),
            keterangan: $('#keterangan').val()
        };

    $.ajax({
        url : "<?=base_url()?>transaksi/selesai",
        type:'POST',
        data : data_kirim
    }).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Transaksi berhasil!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>transaksi/view/<?=$transaksi->id_transaksi?>';
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});

$('#uploadBtn').click(function(e) {
    e.preventDefault();
    var fileInput = $('#fileInput')[0];
    var file = fileInput.files[0];

    if (!file) {
        alert('Silakan pilih file terlebih dahulu.');
        return;
    }

    // Validasi jenis file gambar
    if (!file.type.startsWith('image/')) {
        alert('File yang dipilih bukan gambar.');
        return;
    }

    var formData = new FormData();
    formData.append('file', file);
    formData.append('id_transaksi', '<?=$transaksi->id_transaksi?>');

    Swal.fire({
        text: 'Uploading file.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();

    $.ajax({
        url: '<?=base_url()?>transaksi/upload',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function(response) {
            window.location.href = '<?=base_url()?>transaksi/view/<?=$transaksi->id_transaksi?>';
        },
        error: function(jqXHR, textStatus, errorThrown) {
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});
<?php
endif;
?>

<?php
if(($transaksi->flag_batal=='0')):
?>
$("#b_batal").click(function() {
    Swal.fire({
        text: 'Memproses.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();

    var data_kirim = {
            id_transaksi: '<?=$transaksi->id_transaksi?>',
            keterangan: $('#keterangan').val()
        };

    $.ajax({
        url : "<?=base_url()?>transaksi/batal",
        type:'POST',
        data : data_kirim
    }).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Transaksi berhasil!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>transaksi/view/<?=$transaksi->id_transaksi?>';
            });
        }
    }).fail(function (data) {
        Swal.fire({
            text:'Terjadi kesalahan sistem! ' + data.responseJSON.messages.error,
            icon : 'error'
        });
    });
});
<?php
endif;
?>

<?php
if(($transaksi->flag_validasi=='2')):
?>
$("#b_cetak").click(function(e){
    e.preventDefault();
    var newwindow=window.open('<?=base_url()?>transaksi/multistruk/<?=$transaksi->id_transaksi?>','Kwitansi','height=500,width=500');
    newwindow.print();
    if (window.focus) {newwindow.focus()}
});
<?php
endif
?>
});
</script>

<?php
if(($transaksi->flag_batal=='0') && ($transaksi->flag_validasi<=1)):
?>
<script>
var dialogGrupTransaksi;
var dialogKolektor;
var dialogRumah;
var dialogRumahSimple;
var tbl_dialog_grup_transaksi;
var tbl_dialog_kolektor;
var tbl_dialog_rumah;
var tbl_dialog_rumah_simple;

function setDialogForInput(dialog, dialog_id, button, table_dialog, table_dialog_id, ajax_url, input, display){
    function showDialog() {
        if (!dialog) {
            dialog = new DialogBox(dialog_id, callbackDialog);
        }
        // Show Dialog Box
        dialog.showDialog();
        function callbackDialog(btnName) {
        }
    }

    $("#" + button).click(function(e){
        e.preventDefault();
        showDialog();
    });

    table_dialog = $("#" + table_dialog_id).DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        pageLength:10,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'frtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>' + ajax_url,
            type : 'POST'
        },
        columns: [
            { data: null,
                    width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'nama' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 2,
                data: null,
                defaultContent: '<a href="#" class="btn-pilih btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> Pilih</a>',
            },
        ],
        "initComplete": function(settings, json) {
        }
    });

    table_dialog.on( 'draw.dt', function () {
        var PageInfo = $('#' + table_dialog_id).DataTable().page.info();
        table_dialog.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#' + table_dialog_id + ' tbody').on('click','.btn-pilih',function (e) {
        e.preventDefault();
        var data = table_dialog.row($(this).parents('tr')[0]).data();
        $("#" + display).html(data['nama']);
        $("input[name='" + input + "']").val(data[display]);
        dialog.close();
    });
}

function setDialogForInput2(dialog, dialog_id, button, table_dialog, table_dialog_id, ajax_url, input, display){
    function showDialog() {
        if (!dialog) {
            dialog = new DialogBox(dialog_id, callbackDialog);
        }
        // Show Dialog Box
        dialog.showDialog();
        function callbackDialog(btnName) {
        }
    }

    $("#" + button).click(function(e){
        e.preventDefault();
        showDialog();
    });

    table_dialog = $("#" + table_dialog_id).DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        pageLength:10,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'frtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>' + ajax_url,
            type : 'POST'
        },
        columns: [
            { data: null,
                    width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'kode' },
            { data: 'nama' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 3,
                data: null,
                defaultContent: '<a href="#" class="btn-pilih btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> Pilih</a>',
            },
        ],
        "initComplete": function(settings, json) {
        }
    });

    table_dialog.on( 'draw.dt', function () {
        var PageInfo = $('#' + table_dialog_id).DataTable().page.info();
        table_dialog.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#' + table_dialog_id + ' tbody').on('click','.btn-pilih',function (e) {
        e.preventDefault();
        var data = table_dialog.row($(this).parents('tr')[0]).data();
        $("#" + display).html("[" + data['kode'] + "] " + data['nama']);
        $("input[name='" + input + "']").val(data[display]);
        dialog.close();
    });
}

function setDialogForInput3(dialog, dialog_id, button, table_dialog, table_dialog_id, ajax_url){
    function showDialog() {
        if (!dialog) {
            dialog = new DialogBox(dialog_id, callbackDialog);
        }
        // Show Dialog Box
        dialog.showDialog();
        function callbackDialog(btnName) {
        }
    }

    $("#" + button).click(function(e){
        e.preventDefault();
        showDialog();
    });

    table_dialog = $("#" + table_dialog_id).DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        pageLength:10,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'frtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>' + ajax_url,
            type : 'POST'
        },
        columns: [
            { data: null,
                    width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'kode' },
            { data: 'nama_pemilik' },
            { data: 'alamat' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 4,
                data: null,
                defaultContent: '<a href="#" class="btn-pilih btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> Next</a>',
            },
        ],
        "initComplete": function(settings, json) {
        }
    });

    table_dialog.on( 'draw.dt', function () {
        var PageInfo = $('#' + table_dialog_id).DataTable().page.info();
        table_dialog.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#' + table_dialog_id + ' tbody').on('click','.btn-pilih',function (e) {
        e.preventDefault();
        var data = table_dialog.row($(this).parents('tr')[0]).data();
        dialog.close();
        document.location.href="<?=base_url()?>transaksi/add_detail/<?=$transaksi->id_transaksi?>/" + data['id_kk'];
    });
}

function setDialogForInput4(dialog, dialog_id, button, table_dialog, table_dialog_id, ajax_url){
    function showDialog() {
        if (!dialog) {
            dialog = new DialogBox(dialog_id, callbackDialog);
        }
        // Show Dialog Box
        dialog.showDialog();
        function callbackDialog(btnName) {
        }
    }

    $("#" + button).click(function(e){
        e.preventDefault();
        showDialog();
    });

    table_dialog = $("#" + table_dialog_id).DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        pageLength:10,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'frtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>' + ajax_url,
            type : 'POST'
        },
        columns: [
            { data: null,
                    width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'kode' },
            { data: 'nama_pemilik' },
            { data: 'alamat' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 4,
                data: null,
                defaultContent: '<a href="#" class="btn-pilih btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> Next</a>',
            },
        ],
        "initComplete": function(settings, json) {
        }
    });

    table_dialog.on( 'draw.dt', function () {
        var PageInfo = $('#' + table_dialog_id).DataTable().page.info();
        table_dialog.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#' + table_dialog_id + ' tbody').on('click','.btn-pilih',function (e) {
        e.preventDefault();
        var data = table_dialog.row($(this).parents('tr')[0]).data();
        dialog.close();
        document.location.href="<?=base_url()?>transaksi/add_detail_simple/<?=$transaksi->id_transaksi?>/" + data['id_kk'];
    });
}

setDialogForInput(dialogGrupTransaksi, 'dialogGrupTransaksi', 'b_cari_grup_transaksi', tbl_dialog_grup_transaksi, 'tbl_dialog_grup_transaksi', 'grup_transaksi/ajax_dt', 'id_grup_transaksi', 'id_grup_transaksi');

setDialogForInput2(dialogKolektor, 'dialogKolektor', 'b_cari_kolektor', tbl_dialog_kolektor, 'tbl_dialog_kolektor', 'kolektor/ajax_dt', 'id_kolektor', 'id_kolektor');

setDialogForInput3(dialogRumah, 'dialogRumah', 'b_cari_rumah', tbl_dialog_rumah, 'tbl_dialog_rumah', 'kk/ajax_dt');
setDialogForInput4(dialogRumah, 'dialogRumahSimple', 'b_cari_rumah_simple', tbl_dialog_rumah, 'tbl_dialog_rumah_simple', 'kk/ajax_dt');
</script>

<script>
$(document).ready(function () {
    function init_uploader(target) {
        var uploader = new plupload.Uploader({
            'multi_selection' : false,
            'unique_names' : true,
            'browse_button' : 'btn_browse_'+target,
            'chunk_size':'1024kb',
            'max_retries' : 3,
            'url' : '<?=base_url()?>transaksi/upload2',
        });

        uploader.init();

        uploader.bind("BeforeUpload", function(up,file) {
            var timestamp = Math.floor(Date.now() / 1000); // timestamp detik
            var random = Math.floor(Math.random() * 10000); // angka random 0–9999
            file.name = <?=$transaksi->id_transaksi?>+'_' + timestamp + '_' + random + '_'+file.target_name;

            var params = up.settings.multipart_params;
            params.key = '<?=$transaksi->id_transaksi?>';
            params.Filename = file.name;
        });

        uploader.bind('UploadProgress', function(up, file) {
            /*document.getElementById(file.id).getElementsByTagName('b')[0].innerHTML = '<span>' + file.percent + "%</span>";*/
            $("#filelist_inner").html(file.name + ' : ' + file.percent + '%');
            $("#filelist").attr('aria-valuenow',file.percent);
            $("#filelist_inner").attr('style','width:'+file.percent+'%');
        });

        uploader.bind('FileUploaded', function(up, file, info) {
            var response = JSON.parse(info.response);

            Swal.fire({
                text:'Uploading Sukses',
                icon : 'success',
                allowOutsideClick:false
            }).then(function () {
                var itemHTML = `
                    <div class="item_bukti_bayar mb-2" id="bukti_${response.id}">
                        <div class="mb-2">
                            <img src="<?=base_url()?>bukti_bayar/${response.info.name}">
                        </div>
                        <div class="d-flex justify-content-center gap-2">
                            <a href="<?=base_url()?>bukti_bayar/${response.info.name}" class="btn btn-primary btn-sm" target="_blank">Download</a>
                            <a href="#" data-id="${response.id}" class="b_delete_bukti btn btn-danger btn-sm">Delete</a>
                        </div>
                        <hr/>
                    </div>
                `;

                // Append ke daftar bukti bayar
                $('#list_bukti_bayar').append(itemHTML);
            });
        });

        uploader.bind('Error', function(up, err) {
            up.stop();
            console.log(err);
            Swal.fire({
                text:'Uploading Failed! Error : '+err.message,
                icon : 'error',
                allowOutsideClick:false
            });
        });

        uploader.bind('FilesAdded', function(up, files) {
            if(up.files.length > 1)
            {
                tfile = up.files[0];
                up.removeFile(tfile);
            }

            upload(up);
        });

        return uploader;
    }

    function upload(up)
    {
        if (up.files.length <= 0)
        {
            Swal.fire({
                title:'Upload',
                html:'Tidak ada file yang akan diupload..',
                icon : 'error',
                allowOutsideClick:false
            }).then(function () {
                return false;
            });
        }

        Swal.fire({
            title:'Uploading..',
            html:'<div id="filelist" class="progress" role="progressbar" aria-label="test" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"><div class="progress-bar progress-bar-striped progress-bar-animated" id="filelist_inner" style="width: 0%">0%</div></div>',
            allowOutsideClick:false
        });
        Swal.showLoading();
        up.start();
    }

    var uploader1 = init_uploader('bukti');

    $('#list_bukti_bayar').on('click', '.b_delete_bukti', function(e) {
        e.preventDefault();
        var id = $(this).data("id");

        Swal.fire({
            title:'Delete Data..',
            html: '<p>Yakin ingin menghapus data ini?</p>',
            showDenyButton: true,
            showCancelButton: true,
            confirmButtonText: 'Yes',
            denyButtonText: 'No',
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    text: 'Menghapus data.. Silahkan tunggu..',
                    allowOutsideClick: false
                });
                Swal.showLoading();
                $.post("<?=base_url()?>transaksi/delete_bukti_bayar",{id_bukti_bayar:id}).done(function (data) {
                    if (data.status == 'success')
                    {
                        Swal.fire({
                            text:'Data berhasil dihapus!',
                            icon : 'success'
                        }).then(function () {
                            $("#bukti_" + id).remove();
                        });
                    }
                }).fail(function (data) {
                    Swal.fire({
                        text:'Terjadi kesalahan pada saat operasi delete!',
                        icon : 'error'
                    });
                });
            } else if (result.isDenied) {
                Swal.fire('Operasi dibatalkan..', '', 'info')
            }
        });
    });
});
</script>
<?php
endif;
?>
<?= $this->endSection() ?>