<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row">
    <div class="col-sm-6"><h3 class="mb-0">Rekap Warga</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>transaksi/warga">Rekap Warga</a></li>
        <li class="breadcrumb-item active" aria-current="page">Detail</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                Info Warga
            </div>
            <div class="card-body">
                <table class="table">
                    <tr>
                        <td>Kode</td>
                        <td>: <?=$kk->kode?></td>
                    </tr>
                    <tr>
                        <td>Nama Pemilik</td>
                        <td>: <?=$kk->nama_pemilik?></td>
                    </tr>
                    <tr>
                        <td>Alamat</td>
                        <td>: <?=$kk->alamat?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="col-lg-12">
            <div class="info-box">
                <div class="info-box-content">
                    <span class="info-box-text">Total Penerimaan</span>
                    <span class="info-box-number">Rp. <?=number_format($kk->penerimaan,0,",",".")?></span>
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="info-box">
                <div class="info-box-content">
                    <span class="info-box-text">Total Tunggakan</span>
                    <span class="info-box-number">Rp. <?=number_format($kk->tunggakan,0,",",".")?></span>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row mb-3 g-4">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                Invoice Tunggakan
            </div>
            <div class="card-body">
                <table id="tbl1" class="table table-bordered table-sm nowrap">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th class="dt-filterable">Pembayaran</th>
                            <th class="dt-filterable">Nomor</th>
                            <th class="dt-filterable">Periode</th>
                            <th class="dt-filterable">Iuran</th>
                            <th class="dt-filterable">Diskon</th>
                            <th class="dt-filterable">Sub Total</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row mb-3 g-4">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                Kwitansi Pembayaran
            </div>
            <div class="card-body">
                <table id="tbl2" class="table table-bordered table-sm nowrap">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th class="dt-filterable">Pembayaran</th>
                            <th class="dt-filterable">Nomor Transaksi</th>
                            <th class="dt-filterable">Nomor Kwitansi</th>
                            <th class="dt-filterable">Tanggal</th>
                            <th class="dt-filterable">Periode</th>
                            <th class="dt-filterable">Iuran</th>
                            <th class="dt-filterable">Diskon</th>
                            <th class="dt-filterable">Sub Total</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/js/datatables') ?>

<script type="text/javascript">
$(document).ready(function () {
    var table1 = $("#tbl1").DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        lengthMenu: [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
        pageLength:50,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'Bfrtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>transaksi/ajax_dt_warga_tunggakan/<?=$kk->id_kk?>',
            type : 'POST'
        },
        columns: [
            { data: null,
                 width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'nama_grup_transaksi' },
            { data: 'nomor_invoice' },
            { data: 'periode' },
            { data: 'nominal_invoice', render: DataTable.render.number(",",".",2) },
            { data: 'nominal_diskon', render: DataTable.render.number(",",".",2) },
            { data: 'nominal_akhir', render: DataTable.render.number(",",".",2) },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 7,
                data: null,
                defaultContent: '<button class="btn-view btn btn-block btn-success btn-sm"><span class="fas fa-search"></span>Cetak Invoice</button>',
            },
        ],
        buttons: [
            'pageLength',
            'searchBuilder',
            'copyHtml5',
            {
                extend: 'excelHtml5',
                text: 'Export Excel',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'csvHtml5',
                text: 'Export CSV',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            }
        ],
        "initComplete": function(settings, json) {
        }
    });

    table1.on( 'draw.dt', function () {
        var PageInfo = $('#tbl1').DataTable().page.info();
        table1.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#tbl1 tbody').on('click','.btn-view',function () {
        var data = table1.row($(this).parents('tr')[0]).data();
        var newwindow=window.open('<?=base_url()?>invoice/cetak_invoice/'+data['id_invoice'],'Invoice','height=500,width=500');
        newwindow.print();
        if (window.focus) {newwindow.focus()}
        //document.location.href='<?=base_url()?>transaksi/warga_detail/'+data['id_kk'];
    });
});
</script>

<script type="text/javascript">
$(document).ready(function () {
    var table2 = $("#tbl2").DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        lengthMenu: [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
        pageLength:50,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'Bfrtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>transaksi/ajax_dt_warga_penerimaan/<?=$kk->id_kk?>',
            type : 'POST'
        },
        columns: [
            { data: null,
                 width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'nama_grup_transaksi' },
            { data: 'kode_transaksi' },
            { data: 'nomor' },
            { data: 'tanggal' },
            { data: 'periode' },
            { data: 'total', render: DataTable.render.number(",",".",2) },
            { data: 'total_diskon', render: DataTable.render.number(",",".",2) },
            { data: 'total_akhir', render: DataTable.render.number(",",".",2) },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 9,
                data: null,
                defaultContent: '<button class="btn-view btn btn-block btn-success btn-sm"><span class="fas fa-search"></span>View</button> | <button class="btn-cetak btn btn-block btn-success btn-sm"><span class="fas fa-search"></span>Cetak Kwitansi</button>',
            },
        ],
        buttons: [
            'pageLength',
            'searchBuilder',
            'copyHtml5',
            {
                extend: 'excelHtml5',
                text: 'Export Excel',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'csvHtml5',
                text: 'Export CSV',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            }
        ],
        "initComplete": function(settings, json) {
        }
    });

    table2.on( 'draw.dt', function () {
        var PageInfo = $('#tbl2').DataTable().page.info();
        table2.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#tbl2 tbody').on('click','.btn-cetak',function () {
        var data = table2.row($(this).parents('tr')[0]).data();
        var newwindow=window.open('<?=base_url()?>transaksi/struk/'+data['id_struk'],'Kwitansi','height=500,width=500');
        newwindow.print();
        if (window.focus) {newwindow.focus()}
        //document.location.href='<?=base_url()?>transaksi/warga_detail/'+data['id_kk'];
    });

    $('#tbl2 tbody').on('click','.btn-view',function () {
        var data = table2.row($(this).parents('tr')[0]).data();
        document.location.href='<?=base_url()?>transaksi/view/'+data['id_transaksi'];
    });
});
</script>
<?= $this->endSection() ?>