<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice</title>
    <style>
        @page {
            size: 216mm 110mm;
            margin: 10mm;
        }
        body {
            font-family: 'Courier New', monospace;
            font-size: 12px;
        }
        .header, .footer {
            width: 100%;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }
        .header img {
            height: 40px;
        }
        .header-title {
            flex-grow: 1;
            text-align: center;
            font-size: 16px;
            font-weight: bold;
        }
        .content table {
            width: 100%;
            font-size: 12px;
            margin-top: 10px;
        }
        .content td {
            padding: 4px 0;
        }
        .footer {
            margin-top: 30px;
        }
        .footer-sign {
            display: flex;
            justify-content: space-between;
            font-size: 12px;
            align-items: flex-end;
        }
        .footer-sign .sign-box {
            width: 40%;
            text-align: center;
        }
        .qr-code {
            width: 20%;
            text-align: right;
        }
        .qr-code img {
            height: 80px;
        }
    </style>
</head>
<body>
    <!-- HEADER -->
    <div class="header">
        <div class="header-logo">
            <img src="<?= base_url('assets/logo.png') ?>" alt="Logo">
        </div>
        <div class="header-title">INVOICE</div>
        <div class="header-company">
            <?= $company_name ?>
        </div>
    </div>

    <hr>

    <!-- BODY -->
    <div class="content">
        <table>
            <tr>
                <td width="30%">No. Invoice</td>
                <td>: <?= $invoice_no ?></td>
            </tr>
            <tr>
                <td>Nama Pemilik</td>
                <td>: <?= $owner_name ?></td>
            </tr>
            <tr>
                <td>Alamat</td>
                <td>: <?= $address ?></td>
            </tr>
            <tr>
                <td>Periode Tagihan</td>
                <td>: <?= $billing_period ?></td>
            </tr>
            <tr>
                <td>Nominal</td>
                <td>: Rp <?= number_format($amount, 0, ',', '.') ?></td>
            </tr>
        </table>
    </div>

    <!-- FOOTER -->
    <div class="footer">
        <div class="footer-sign">
            <div class="sign-box">
                Operator<br><br><br>
                ( <?= $operator ?> )
            </div>
            <div class="sign-box">
                Penerima<br><br><br>
                ( <?= $receiver ?> )
            </div>
            <div class="qr-code">
                <img src="<?= $qr_code ?>" alt="QR Code">
            </div>
        </div>
    </div>
</body>
</html>