<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Transaksi</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>kolektor/pembatalan">Pembatalan Transaksi</a></li>
        <li class="breadcrumb-item active" aria-current="page">View</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>kolektor/transaksi/pembatalan" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-8">
        <div class="card card-warning card-outline mb-4">
            <div class="card-header">
                <div class="card-title">Header Transaksi</div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <label for="kode" class="col-sm-3 col-form-label">Kode : </label>
                    <div class="col-sm-9 d-flex align-items-center">
                        <span class="form-control" id="kode" class="text-secondary"><?=$transaksi->kode?></span>
                    </div>
                </div>
                <div class="row mb-3">
                    <label for="id_grup_transaksi" class="col-sm-3 col-form-label">Grup Transaksi : </label>
                    <div class="col-sm-9 d-flex align-items-center">
                        <span class="form-control" id="id_grup_transaksi" class="text-secondary"><?=$transaksi->nama_grup_transaksi?></span>
                        <input type="hidden" name="id_grup_transaksi" value="<?=$transaksi->id_grup_transaksi?>">
                    </div>
                </div>
                <div class="row mb-3">
                    <label for="id_kolektor" class="col-sm-3 col-form-label">Kolektor : </label>
                    <div class="col-sm-9 d-flex align-items-center">
                        <span class="form-control" id="id_kolektor" class="text-secondary">[<?=$transaksi->kode_kolektor?>] <?=$transaksi->nama_kolektor?></span>
                        <input type="hidden" name="id_kolektor" value="<?=$transaksi->id_kolektor?>">
                    </div>
                </div>
                <div class="row mb-3">
                    <label for="id_operator" class="col-sm-3 col-form-label">Operator : </label>
                    <div class="col-sm-9 d-flex align-items-center">
                        <span class="form-control" id="id_operator" class="text-secondary"><?=$transaksi->nama_operator?></span>
                    </div>
                </div>
                <div class="row mb-3">
                    <label for="status" class="col-sm-3 col-form-label">Status : </label>
                    <div class="col-sm-9 d-flex align-items-center">
                        <span class="form-control" id="status" class="text-secondary"><?=$transaksi->status_validasi?></span>
                    </div>
                </div>
                <div class="row mb-3">
                    <label for="tanggal" class="col-sm-3 col-form-label">Tanggal : </label>
                    <div class="col-sm-9">
                        <input type="date" class="form-control" id="tanggal" name="tanggal" value="<?=$transaksi->tanggal?>">
                        <span id="etanggal" class="text-danger invalid-feedback"></span>
                    </div>
                </div>
            </div>
        </div>     
    </div>
</div>

<div class="row mb-4">
    <div class="col-lg-12">
        <div class="card card-warning card-outline">
            <div class="card-header">
                <div class="card-title d-flex justify-content-between w-100">
                    <div>Detail Transaksi</div>
                </div>
            </div>
            <div class="card-body p-0">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Kode</th>
                            <th>Alamat</th>
                            <th>Periode</th>
                            <th>Sub Total</th>
                            <th>Diskon</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no=1;
                        foreach($detail_transaksi as $item):
                        ?>
                        <tr>
                            <td><?=$no?></td>
                            <td><?=$item['kode_kk']?></td>
                            <td><?=$item['alamat']?></td>
                            <td><?=$item['periode']?></td>
                            <td>Rp. <?=number_format($item['total'],0,",",".")?></td>
                            <td>Rp. <?=number_format($item['total_diskon'],0,",",".")?></td>
                            <td>Rp. <?=number_format($item['total_akhir'],0,",",".")?></td>
                        </tr>
                        <?php
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Rekap</div>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <tbody>
                        <tr>
                            <td>Diskon :</td>
                            <td>Rp. <?=number_format($total_diskon,2,".",",")?></td>
                        </tr>
                        <tr>
                            <td>Total :</td>
                            <td>Rp. <?=number_format($total_akhir,2,".",",")?></td>
                        </tr>
                        <tr>
                            <td>Status Batal :</td>
                            <td><?=$transaksi->status_batal?></td>
                        </tr>
                        <tr>
                            <td>Status Validasi :</td>
                            <td><?=$transaksi->status_validasi?></td>
                        </tr>
                        <tr>
                            <td>Tanggal Validasi :</td>
                            <td><?=$transaksi->tanggal_validasi?></td>
                        </tr>
                        <tr>
                            <td>Keterangan :</td>
                            <td><?=$transaksi->keterangan_validasi?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Pembayaran</div>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <tbody>
                        <tr>
                            <td>Jenis Pembayaran :</td>
                            <td>
                                <?=$transaksi->jenis_pembayaran?>
                            </td>
                        </tr>
                        <tr>
                            <td>Tanggal Pembayaran :</td>
                            <td><?=$transaksi->tanggal_pembayaran?></td>
                        </tr>
                        <tr>
                            <td>Nama Penerima :</td>
                            <td><?=$transaksi->pembayar?></td>
                        </tr>
                        <tr>
                            <td>No. Telp :</td>
                            <td><?=$transaksi->no_telp?></td>
                        </tr>
                    </tbody>
                </table>
                <hr/>
                <table class="table table-stripped">
                    <tbody>
                        <tr>
                            <td colspan="2"><b>Bukti Pembayaran :</b></td>
                        </tr>
                        <?php
                        foreach($bukti_bayar as $item):
                        ?>
                        <tr>
                            <td><img src="<?=base_url()?>kolektor/bukti_bayar/<?=$item['fnama']?>"><br/><a href="<?=base_url()?>kolektor/transaksi/download_bukti_bayar/<?=$transaksi->id_transaksi?>" class="btn btn-primary btn-sm" target="_blank">Download</a>
                            <?php
                            if(($transaksi->flag_batal == '0') && ($transaksi->flag_validasi <= 1)) :
                            ?>
                            | <a href="<?=base_url()?>kolektor/transaksi/delete_bukti_bayar/<?=$transaksi->id_transaksi?>" class="btn btn-danger btn-sm">Delete</a></td>
                            <?php
                            endif;
                            ?>
                        </tr>
                        <?php
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<script type="text/javascript">
$(document).ready(function() {


});
</script>


<?= $this->endSection() ?>