<!doctype html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <title>Comp Pay</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="title" content="Comp Pay | Login" />
        <meta name="author" content="FormatTeknologi" />
        <meta
            name="description"
            content="Comp Pay For General Payment"
        />
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fontsource/source-sans-3@5.0.12/index.css" integrity="sha256-tXJfXfp6Ewt1ilPzLDtQnJV4hclT9XuaZUKyUvmyr+Q=" crossorigin="anonymous" />
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.10.1/styles/overlayscrollbars.min.css" integrity="sha256-tZHrRjVqNSRyWg2wbppGnT833E/Ys0DHWGwT04GiqQg=" crossorigin="anonymous" />
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" integrity="sha256-9kPW/n5nn53j4WMRYAxe9c1rCY96Oogo/MKSVdKzPmI=" crossorigin="anonymous" />
        <link rel="stylesheet" href="<?=base_url()?>theme/css/adminlte.css" />
    </head>
    <body class="login-page">
        <div class="inner-login d-flex flex-column">
            <div>
                <h3><b>Comp</b> Pay</h3>
                <p>Welcome to Comp Pay, the smart and secure way to manage your payments effortlessly — anytime, anywhere.</p>
            </div>
            <div class="login-box">
                <div class="card card-outline card-primary">
                    <div class="card-header">
                        <h3><b>Login</b></h3>
                    </div>
                    <div class="card-body login-card-body">
                        <p>Sign in to start your session</p>
                        <?php if (session('error') !== null) : ?>
                            <div class="alert alert-danger" role="alert"><?= session('error') ?></div>
                        <?php elseif (session('errors') !== null) : ?>
                            <div class="alert alert-danger" role="alert">
                                <?php if (is_array(session('errors'))) : ?>
                                    <?php foreach (session('errors') as $error) : ?>
                                        <?= $error ?>
                                        <br>
                                    <?php endforeach ?>
                                <?php else : ?>
                                    <?= session('errors') ?>
                                <?php endif ?>
                            </div>
                        <?php endif ?>
                        <?php if (session('message') !== null) : ?>
                        <div class="alert alert-success" role="alert"><?= session('message') ?></div>
                        <?php endif ?>
                        <form action="<?= url_to('login') ?>" method="post">
                            <div class="input-group mb-1">
                                <div class="form-floating">
                                    <input type="email" class="form-control" id="floatingEmailInput" name="email" inputmode="email" autocomplete="email" placeholder="<?= lang('Auth.email') ?>" value="<?= old('email') ?>" required>
                                    <label for="loginEmail">Username</label>
                                </div>
                                <div class="input-group-text"><span class="bi bi-envelope"></span></div>
                            </div>
                            <div class="input-group mb-1">
                                <div class="form-floating">
                                    <input type="password" class="form-control" id="floatingPasswordInput" name="password" inputmode="text" autocomplete="current-password" placeholder="<?= lang('Auth.password') ?>" required>
                                    <label for="loginPassword">Password</label>
                                </div>
                                <div class="input-group-text"><span class="bi bi-lock-fill"></span></div>
                            </div>
                            <div class="row mt-3">
                                <!-- /.col -->
                                <div class="col-12">
                                    <div class="d-grid gap-2">
                                    <button type="submit" class="btn btn-primary">Sign In</button>
                                    </div>
                                </div>
                                <!-- /.col -->
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <div id="login_bg">
            
        </div>

        <script src="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.10.1/browser/overlayscrollbars.browser.es6.min.js" integrity="sha256-dghWARbRe2eLlIJ56wNB+b760ywulqK3DzZYEpsg2fQ=" crossorigin="anonymous"></script>
        
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
        
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js" integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous"></script>
        
        <script src="<?=base_url()?>theme/js/adminlte.js"></script>
    </body>
</html>