<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Rekap Bukti Pembayaran</title>
    <style>
        @page {
            margin: 8mm 8mm 8mm 8mm;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        table.grid {
            width: 100%;
            border-collapse: collapse;
        }
        table.grid td {
            width: 33%;
            padding: 5px;
            text-align: center;
            vertical-align: top;
            border: 1px solid #ccc;
        }
        img.bukti {
            max-width: 100%;
            height: auto;
            max-height: 400px;
        }
        small {
            display: block;
            margin-top: 5px;
            color: #333;
        }
    </style>
</head>
<body>

    <h2>Rekap Bukti Pembayaran<br>
        <small><?= date('d M Y', strtotime($tanggal_cetak)) ?></small>
    </h2>

    <table class="grid">
        <?php 
        $counter = 0;
        foreach ($bukti as $trx): 
            if ($counter % 3 == 0) echo "<tr>";
        ?>
            <td>
                <img class="bukti" src="<?=$trx['gambar'] ?>" alt="Bukti Bayar">
                <small>No Transaksi: <?= $trx['nomor'] ?></small>
                <small>Tanggal: <?= date('d-m-Y', strtotime($trx['tanggal'])) ?></small>
                <!-- Tambahkan informasi lain jika perlu -->
            </td>
        <?php 
            $counter++;
            if ($counter % 3 == 0) echo "</tr>";
        endforeach; 
        if ($counter % 3 != 0) {
            // Isi kolom kosong jika baris terakhir tidak lengkap
            $remaining = 3 - ($counter % 3);
            for ($i = 0; $i < $remaining; $i++) echo "<td></td>";
            echo "</tr>";
        }
        ?>
    </table>

</body>
</html>
