<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Kwitansi Pembayaran</title>
    <style>
        @page {
            size: 241.3mm 93.2mm;
            margin: 5mm;
        }
        body {
            font-family: 'Courier New', monospace;
            font-size: 10pt;
        }

        .struk_wrapper{
            margin: 0px;
            border:1px solid gray;
        }

        .header, .footer {
            width: 100%;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0px;
        }
        .header img {
            height: 40px;
        }
        .header-title {
            flex-grow: 1;
            text-align: center;
            font-size: 10pt;
            font-weight: bold;
        }

        .header-company{
            text-align: center;
            font-weight: bold;
        }
        .content{
            padding: 0px;
            margin:0px;
        }
        .content table {
            width: 100%;
            font-size: 10pt;
            margin-top: 0px;
        }
        .content td {
            padding: 0px 0;
        }
        .footer {
            margin-top: 0px;
            padding:0px;
        }
        .footer table {
            width: 100%;
        }
        .footer-sign {
            display: flex;
            justify-content: space-between;
            font-size: 10pt;
            align-items: flex-end;
        }
        .footer-sign .sign-box {
            width: 40%;
            text-align: center;
        }
        .qr-code {
            width: 20%;
            text-align: right;
        }
        .qr-code img {
            max-height: 40px;
        }

        .penggaris {
            border:0.5px dotted gray;
        }

        hr{
            border-collapse: collapse;
            border:none;
            border-top:1px dashed gray;
            padding: 0px;
            margin: 0px;
        }

        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
<?php 
$i=0;
for ($i=0;$i<count($struks);$i++):
$struk = $struks[$i];
?>
<div class="struk_wrapper">
    <!-- HEADER -->
    <div class="header">
        <table style="width: 100%;">
            <tr>
                <td class="header-logo" width="20%"><img src="<?=$company_logo?>" alt="Logo"></td>
                <td class="header-title">KWITANSI PEMBAYARAN</td>
                <td class="header-company" width="30%"><?= $company_name ?><br/><?= $struk['nomor_struk'] ?><br/><?= $struk['nomor_transaksi'] ?></td>
            </tr>
        </table>
    </div>

    <hr>

    <!-- BODY -->
    <div class="content">
        <table>
            <tr>
                <td width="16%">Tgl. Transaksi</td>
                <td colspan="3">: <?= date('d M Y', strtotime($struk['tanggal'])) ?></td>
            </tr>
            <!-- <tr>
                <td>No. Invoice</td>
                <td colspan="3">: <?= $struk['nomor_invoice'] ?></td>
            </tr> -->
            <tr>
                <td class="penggaris" colspan="4"></td>
            </tr>
            <tr>
                <td>Kode</td>
                <td>: <?= $struk['kode_rumah'] ?></td>
                <td>Nama Pemilik</td>
                <td>: <?= $struk['nama_pemilik'] ?></td>
            </tr>
            <tr>
                <td>Alamat</td>
                <td colspan="3">: <?= $struk['alamat'] ?></td>
            </tr>
            <tr>
                <td>Periode Tagihan</td>
                <td colspan="3">: <?= $struk['periode'] ?></td>
            </tr>
            <tr>
                <td>Jenis Pembayaran</td>
                <td>: <?= $struk['jenis_pembayaran'] ?></td>
                <td width="16%">Tgl. Pembayaran</td>
                <td>: <?= $struk['tanggal_pembayaran'] ?></td>
            </tr>
            <tr>
                <td>Nominal</td>
                <td colspan="3">: Rp <?= number_format($struk['nominal'], 0, ',', '.') ?>,-</td>
            </tr>
            <tr>
                <td>Kolektor</td>
                <td colspan="3">: <?= $struk['kolektor'] ?></td>
            </tr>
        </table>
    </div>
    <hr>
    <!-- FOOTER -->
    <div class="footer">
        <table>
            <tr>
                <td width="70%">
                    <table>
                        <tr>
                            <td width="50%">Operator</td>
                            <td width="50%">Penerima</td>
                            <td></td>
                        </tr>
                        <tr><td colspan="2" style="height: 30px;"></td><td></td></tr>
                        <tr><td>( <?= $struk['operator'] ?> )</td><td>( <?= $struk['receiver'] ?> )</td><td></td></tr>
                    </table>
                </td>
                <td>
                    <table>
                        <tr><td><img src="<?= $struk['qr_code'] ?>" alt="QR Code"></td></tr>
                    </table>
                </td>
            </tr>
        </table>
        
       
        <!-- <div class="footer-sign">
            <div class="sign-box">
                Operator<br><br><br>
                
            </div>
            <div class="sign-box">
                Penerima<br><br><br>
                
            </div>
            <div class="qr-code">
                <img src="<?= $struk['qr_code'] ?>" alt="QR Code">
            </div>
        </div> -->
    </div>
</div>
    <?php
    if($i<(count($struks)-1)):
    ?>
    <div class="page-break"></div>
    <?php
    endif;
    ?>
<?php endfor; ?>
</body>
</html>
