<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Voucher Penerimaan Harian</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 30px;
        }

        .title {
            text-align: center;
            font-weight: bold;
            font-size: 16px;
        }

        .sub-title {
            text-align: center;
            font-size: 12px;
            margin-bottom: 30px;
        }

        .header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .header-left {
            font-weight: bold;
            width: 50%;
            float:left;
        }

        .header-left small {
            font-weight: normal;
            display: block;
        }

        .header-right {
            text-align: right;
            width: 50%;
            float:left;
        }

        .table-detail {
            width: 100%;
            border: 1px solid #000;
            border-collapse: collapse;
            margin-bottom: 20px;
            margin-top: 80px;
        }

        .table-detail td {
            padding: 6px;
            border: none;
        }

        .table-detail tr:not(:last-child) td {
            border-bottom: 1px dotted #000;
        }

        .table-detail .name-col {
            width: 70%;
        }

        .table-detail .amount-col {
            width: 30%;
            text-align: right;
        }

        .total {
            text-align: right;
            font-weight: bold;
            /* margin-top: -10px; */
        }

        .signatures {
            width: 100%;
            margin-top: 10px;
            display: flex;
            justify-content: space-between;
            text-align: center;
        }

        .signature-box {
            width: 30%;
            border: 1px solid #000;
            padding: 10px;
            height: 100px;
            float:left;
        }

        .signature-label {
            margin-bottom: 70px;
        }

        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
<?php 
$indeks1=0;
for ($indeks1=0;$indeks1<count($harian);$indeks1++):
$grup = $harian[$indeks1]['grup'];
?>
    <div class="title"><?=$company_name?></div>
    <div class="sub-title">
        <?php foreach($rekbank as $item):?>
        (<?=$item['nama_bank']?> : <?=$item['no_rek']?> : <?=$item['atas_nama']?>)<br/>
        <?php endforeach; ?>
    </div>

    <div class="header">
        <div class="header-left">
            BUKTI PENERIMAAN BANK
            <small>Dari : <?=$company_name?></small>
            <small>Pendapatan <?=$company_name?>, Tanggal <?=$harian[$indeks1]['tanggal_cetak']?></small>
        </div>
        <div class="header-right">
            No. Voucher : <?=$harian[$indeks1]['no_voucher']?><br/>
            Cheque / Giro : Transfer / Cash
        </div>
    </div>

    <table class="table-detail">
        <!-- Ulangi bagian <tr> berikut untuk setiap item -->
        <?php
        foreach($grup as $item_grup):
            ?>
            <tr>
                <td class="name-col" colspan="2"><b><?=$item_grup['nama']?></b></td>
            </tr>
            <tr>
                <td class="name-col" colspan="2"><hr/></td>
            </tr>
            <tr>
                <td class="name-col" colspan="2"><b>Kantor</b></td>
            </tr>
            <?php
            foreach($item_grup['kantor']['data'] as $item_detail):
                ?>
                <tr>
                    <td class="name-col"><?=$item_detail['jenis']?> Kantor</td>
                    <td class="amount-col">Rp. <?=number_format($item_detail['nominal'],0,',','.')?></td>
                </tr>
                <?php
            endforeach;
            ?>
            <tr>
                <td class="name-col"><b>Sub Total</b></td>
                <td class="amount-col"><b>Rp. <?=number_format($item_grup['kantor']['sub_total'],0,',','.')?></b></td>
            </tr>
            <tr>
                <td class="name-col" colspan="2"></td>
            </tr>
            <tr>
                <td class="name-col" colspan="2"><b>Kolektor</b></td>
            </tr>
            <?php
            foreach($item_grup['kolektor']['data'] as $item_detail):
                ?>
                <tr>
                    <td class="name-col"><?=$item_detail['jenis']?> Kolektor</td>
                    <td class="amount-col">Rp. <?=number_format($item_detail['nominal'],0,',','.')?></td>
                </tr>
                <?php
            endforeach;
            ?>
            <tr>
                <td class="name-col"><b>Sub Total</b></td>
                <td class="amount-col"><b>Rp. <?=number_format($item_grup['kolektor']['sub_total'],0,',','.')?></b></td>
            </tr>
            <tr>
                <td class="name-col" colspan="2"></td>
            </tr>
            <tr>
                <td class="name-col"><b>Sub Total Grup</b></td>
                <td class="amount-col"><b>Rp. <?=number_format($item_grup['sub_total'],0,',','.')?></b></td>
            </tr>
            <tr>
                <td class="name-col" colspan="2"><hr/></td>
            </tr>
            <?php
        endforeach;
        ?>
        <tr>
            <td class="name-col"><b>Total</b></td>
            <td class="amount-col"><b>Rp. <?=number_format($harian[$indeks1]['total'],0,',','.')?></b></td>
        </tr>
        <!-- ... -->
    </table>

    <div class="total">Tanggal : <?=$harian[$indeks1]['tanggal_cetak']?></div>

    <div class="signatures">
        <div class="signature-box">
            <div class="signature-label">Disetujui Oleh</div>
            <div class="signature-ttd">(<?=$voucher_disetujui?>)</div>
        </div>
        <div class="signature-box">
            <div class="signature-label">Dibuat Oleh</div>
            <div class="signature-ttd">(<?=$pembuat?>)</div>
        </div>
        <div class="signature-box">
            <div class="signature-label">Diperiksa Oleh</div>
            <div class="signature-ttd">(<?=$voucher_diperiksa?>)</div>
        </div>
    </div>
    <?php
    if($indeks1<(count($harian)-1)):
    ?>
    <div class="page-break"></div>
    <?php
    endif;
    ?>
<?php endfor; ?>
</body>
</html>
