<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice Pembayaran</title>
    <style>
        @page {
            size: 241.3mm 93.2mm;
            margin: 5mm;
        }
        body {
            font-family: 'Courier New', monospace;
            font-size: 10pt;
        }

        .struk_wrapper{
            margin: 0px;
            border:1px solid gray;
        }

        .header, .footer {
            width: 100%;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0px;
        }
        .header img {
            height: 40px;
        }
        .header-title {
            flex-grow: 1;
            text-align: center;
            font-size: 10pt;
            font-weight: bold;
        }

        .header-company{
            text-align: center;
            font-weight: bold;
        }
        .content{
            padding: 0px;
            margin:0px;
        }
        .content table {
            width: 100%;
            font-size: 10pt;
            margin-top: 0px;
        }
        .content td {
            padding: 0px 0;
        }
        .footer {
            margin-top: 0px;
            padding:0px;
        }
        .footer table {
            width: 100%;
        }
        .footer-sign {
            display: flex;
            justify-content: space-between;
            font-size: 10pt;
            align-items: flex-end;
        }
        .footer-sign .sign-box {
            width: 40%;
            text-align: center;
        }
        .qr-code {
            width: 20%;
            text-align: right;
        }
        .qr-code img {
            max-height: 40px;
        }

        .penggaris {
            border:0.5px dotted gray;
        }

        hr{
            border-collapse: collapse;
            border:none;
            border-top:1px dashed gray;
            padding: 0px;
            margin: 0px;
        }

        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
<?php 
$i=0;
for ($i=0;$i<count($invoices);$i++):
$invoice = $invoices[$i];
?>
<div class="struk_wrapper">
    <!-- HEADER -->
    <div class="header">
        <table style="width: 100%;">
            <tr>
                <td class="header-logo" width="20%"><img src="<?= $company_logo ?>" alt="Logo"></td>
                <td class="header-title">INVOICE</td>
                <td class="header-company" width="30%"><?= $company_name ?><br/><?= $invoice['nomor_invoice'] ?></td>
            </tr>
        </table>
    </div>

    <hr>

    <!-- BODY -->
    <div class="content">
        <table>
            <tr>
                <td width="16%">Tanggal</td>
                <td colspan="3">: <?= date('d M Y', strtotime($invoice['tanggal'])) ?></td>
            </tr>
            <tr>
                <td class="penggaris" colspan="4"></td>
            </tr>
            <tr>
                <td>Kode</td>
                <td>: <?= $invoice['kode_rumah'] ?></td>
                <td>Nama Pemilik</td>
                <td>: <?= $invoice['nama_pemilik'] ?></td>
            </tr>
            <tr>
                <td>Alamat</td>
                <td colspan="3">: <?= $invoice['alamat'] ?></td>
            </tr>
            <tr>
                <td>Periode Tagihan</td>
                <td colspan="3">: <?= $invoice['periode'] ?></td>
            </tr>
            <tr>
                <td>Nominal</td>
                <td colspan="3">: Rp <?= number_format($invoice['nominal'], 0, ',', '.') ?>,-</td>
            </tr>
            <tr>
                <td>Status</td>
                <td colspan="3">: <?php 
                    if($invoice['status']=='0'){
                        echo 'Unpaid';
                    }else{
                        echo 'Paid';
                    }
                ?> <?php if(isset($invoice['nomor_transaksi'])) { echo " Trans : ".$invoice['nomor_transaksi']; } ?></td>
            </tr>
        </table>
    </div>
    <hr>
    <!-- FOOTER -->
    <div class="footer">
        <table>
            <tr>
                <td width="70%">
                    <table>
                        <tr>
                            <td width="50%">Operator</td>
                            <td width="50%">Penerima</td>
                            <td></td>
                        </tr>
                        <tr><td colspan="2" style="height: 30px;"></td><td></td></tr>
                        <tr><td>( <?= $invoice['operator'] ?> )</td><td>( <?= $invoice['receiver'] ?> )</td><td></td></tr>
                    </table>
                </td>
                <td>
                    <table>
                        <tr><td><img src="<?= $invoice['qr_code'] ?>" alt="QR Code"></td></tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
</div>
    <?php
    if($i<(count($invoices)-1)):
    ?>
    <div class="page-break"></div>
    <?php
    endif;
    ?>
<?php endfor; ?>
</body>
</html>
