<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

  <script src="<?=base_url()?>assets/plugins/jquery/jquery.js"></script>
  <style>
    :root {
      --main-orange: #ff7700;
    }
    body {
      background-color: #ffffff;
    }
    .navbar {
      background-color: var(--main-orange);
    }
    .navbar-brand {
      color: white;
      font-weight: bold;
    }
    .info-box {
      background-color: #f8f9fa;
      border-radius: 10px;
      padding: 1rem;
      margin-top: 1rem;
    }
    .menu-btn {
        text-decoration: none;
      border: none;
      /* background-color: var(--main-orange); */
      color: orange;
      border:1px solid orange;
      border-radius: 10px;
      padding: 1rem;
      width: 100%;
      height: 100%;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      transition: background-color 0.3s;
    }
    .menu-btn:hover {
      background-color: #e86600;
      color:white;
    }
    .menu-icon {
      font-size: 1.8rem;
      margin-bottom: 0.5rem;
    }
    .announcement-box {
      margin-top: 2rem;
    }

    .navbar-brand{
        font-size: 12px;
    }
  </style>
</head>
<body>

  <!-- Navbar -->
  <nav class="navbar shadow-sm bg-gradient">
    <div class="container-fluid d-flex align-items-center">
      <img src="<?=base_url()?>img/logo.png" alt="Logo" style="height: 40px; margin-right: 10px;">
      <span class="navbar-brand mb-0 h5 text-sm"><?=COMPANY_NAME?></span>
    </div>
  </nav>

  <!-- Konten -->
  <div class="container mt-3">
    
    <!-- Info Rumah -->
    <div class="info-box shadow-sm">
      <h6 class="mb-1"><strong>Kode Rumah:</strong> <?=$kk['kode']?></h6>
      <p class="mb-0"><strong>Pemilik:</strong> <?=$kk['nama_pemilik']?></p>
      <p class="mb-0"><strong>Alamat:</strong> <?=$kk['alamat']?></p>
    </div>

    <!-- Tombol Menu -->
    <div class="row text-center mt-4 g-3">
      <div class="col-6 col-md-4">
        <a href="<?=base_url()?>vwarga/pembayaran" class="menu-btn">
          <i class="bi bi-credit-card menu-icon"></i>
          Pembayaran
        </a>
      </div>
      <div class="col-6 col-md-4">
        <a href="<?=base_url()?>vwarga/riwayat" class="menu-btn">
          <i class="bi bi-clock-history menu-icon"></i>
          Riwayat
        </a>
      </div>
      <!-- Tambahkan tombol tambahan di sini jika diperlukan -->
    </div>

    <!-- Pengumuman -->
    <div class="announcement-box">
      <h5>Pengumuman</h5>
      <ul class="list-group">
        <!-- <li class="list-group-item">Air akan dimatikan sementara pada 2 Juni 2025.</li>
        <li class="list-group-item">Iuran kebersihan bulan Mei jatuh tempo 5 Juni 2025.</li>
        <li class="list-group-item">Mohon update data rumah via aplikasi.</li> -->
      </ul>
    </div>

  </div>

</body>
</html>
