<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Riwayat Pembayaran</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    :root {
      --main-orange: #ff7700;
    }
    body {
      background-color: #ffffff;
      padding: 1rem;
    }
    .navbar {
      background-color: var(--main-orange);
    }
    .navbar-brand {
      color: white;
      font-weight: bold;
      font-size: 12px;
    }
    .card-riwayat {
      border-left: 4px solid var(--main-orange);
      cursor: pointer;
      transition: background 0.2s ease;
    }
    .card-riwayat:hover {
      background-color: #f8f9fa;
    }
    .badge {
        color:#212529;
    }
    .badge-pending {
      background-color: #ffc107;
      color: #212529;
    }
    .badge-canceled {
      background-color: #ff7700;
      color: #212529;
    }
    .badge-completed {
      background-color: #28a745;
    }
    .trx-title {
      font-weight: 600;
      font-size: 1rem;
    }
    .trx-detail {
      font-size: 0.9rem;
      color: #555;
    }
  </style>
</head>
<body>
<!-- Navbar -->
  <nav class="navbar shadow-sm bg-gradient">
    <div class="container-fluid d-flex align-items-center">
      <img src="<?=base_url()?>img/logo.png" alt="Logo" style="height: 40px; margin-right: 10px;">
      <span class="navbar-brand mb-0 h5 text-sm"><?=COMPANY_NAME?></span>
    </div>
  </nav>
  <div class="container">
    <!-- Judul -->
    <h4 class="fw-bold mb-4">Riwayat Pembayaran</h4>

    <!-- List Riwayat Pembayaran -->
    <div class="list-group">
    <?php
    foreach($transaksi as $item):
        $tanggal_cetak = date("d M Y",strtotime($item['tanggal']));
    ?>
      <!-- Item 1 -->
      <div class="list-group-item card-riwayat mb-2" onclick="goToDetail('<?=$item['id_transaksi']?>')">
        <div class="d-flex justify-content-between align-items-center">
          <div>
            <div class="trx-title"><?=$item['kode']?></div>
            <div class="trx-detail">Tanggal: <?=$tanggal_cetak?> | Periode: <?=$item['periode']?></div>
            <div class="trx-detail">Nominal: Rp <?=number_format($item['total_akhir'],0,".",",")?></div>
          </div>
          <?php
            if($item['flag_validasi']=='2'):
          ?>
          <span class="badge badge-completed">Completed</span>
          <?php
            elseif($item['flag_validasi']=='1'):
          ?>
          <span class="badge badge-pending">Pending</span>
          <?php
            elseif($item['flag_validasi']=='3'):
          ?>
          <span class="badge badge-canceled">Canceled</span>
          <?php
            else:
          ?>
          <span class="badge badge-canceled">Draft</span><span>Silahkan hubungi operator untuk informasi status</span>
          <?php
          endif;
          ?>
        </div>
      </div>

    <?php
    endforeach;
    ?>
    </div>
  </div>

  <script>
    function goToDetail(trxId) {
      // Arahkan ke halaman detail transaksi
      window.location.href = `<?=base_url()?>vwarga/riwayatdetail/${trxId}`;
    }
  </script>

</body>
</html>
