<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Upload Bukti Pembayaran</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="<?=base_url()?>assets/plugins/jquery/jquery.js"></script>
  <style>
    :root {
      --main-orange: #ff7700;
    }
    body {
      padding-bottom: 100px;
      background-color: #fff;
    }
    .navbar {
      background-color: var(--main-orange);
    }
    .navbar-brand {
      color: white;
      font-weight: bold;
      font-size: 12px;
    }
    .sticky-footer {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background-color: white;
      border-top: 1px solid #ddd;
      padding: 1rem;
      z-index: 999;
      box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.05);
    }
    .btn-next {
      background-color: var(--main-orange);
      color: white;
      border: none;
      width: 100%;
    }
    .btn-next:hover {
      background-color: #e86600;
    }
    .preview-img {
      width: 100%;
      max-height: 200px;
      object-fit: contain;
      border: 1px solid #ddd;
      border-radius: 10px;
      margin-bottom: 0.5rem;
    }
    .upload-group {
      margin-bottom: 1rem;
    }
  </style>
</head>
<body>
    <!-- Navbar -->
  <nav class="navbar shadow-sm bg-gradient">
    <div class="container-fluid d-flex align-items-center">
      <img src="<?=base_url()?>img/logo.png" alt="Logo" style="height: 40px; margin-right: 10px;">
      <span class="navbar-brand mb-0 h5 text-sm"><?=COMPANY_NAME?></span>
    </div>
  </nav>

  <div class="container py-4">
    <!-- Total Iuran -->
    <h4 class="fw-bold mb-3">Upload Bukti Pembayaran</h4>
    <div class="alert alert-info">
      Total Iuran: <strong>Rp <?=number_format($total,0,".",",")?></strong>
    </div>

    <!-- Upload Bukti -->
    <form id="uploadForm">
      <div id="uploadContainer"></div>
    </form>
  </div>

  <!-- Sticky Footer -->
  <div class="sticky-footer d-flex justify-content-end">
    <button class="btn btn-next" id="btnNext">Next</button>
  </div>

<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<script>
let uploadIndex = 0;

// Fungsi buat satu upload field
function addUploadField() {
    uploadIndex++;
    const id = `upload_${uploadIndex}`;

    const html = `
    <div class="upload-group" id="${id}_group">
        <img src="" id="${id}_preview" class="preview-img d-none">
        <input type="file" name="bukti[]" accept="image/*" class="form-control mb-2" id="${id}_input">
        <button type="button" class="btn btn-danger btn-sm d-none" id="${id}_delete">Hapus</button>
    </div>
    `;

    $('#uploadContainer').append(html);

    // Event input file
    $(`#${id}_input`).on('change', function () {
        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function (e) {
                $(`#${id}_preview`).attr('src', e.target.result).removeClass('d-none');
                $(`#${id}_delete`).removeClass('d-none');
                $(`#${id}_input`).addClass('d-none');
            };
            reader.readAsDataURL(file);

            // Tambahkan field baru hanya jika ini adalah terakhir
            if ($('.upload-group').last().attr('id') === `${id}_group`) {
                addUploadField();
            }
        }
    });

    // Event hapus
    $(`#${id}_delete`).on('click', function () {
        $(`#${id}_group`).remove();
    });
}

// Inisialisasi pertama
$(document).ready(function () {
    addUploadField();
});

// Kirim AJAX ke CI4
$('#btnNext').on('click', function (e) {
    e.preventDefault();

    const formData = new FormData($('#uploadForm')[0]);
    console.log(formData);

    $.ajax({
        url: '<?= base_url('vwarga/uploadbuktiproses') ?>', // sesuaikan route CI4 kamu
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        beforeSend: function () {
            $('#btnNext').prop('disabled', true).text('Mengirim...');
            Swal.fire({
                text: 'Menyimpan data.. Silahkan tunggu..',
                allowOutsideClick: false
            });
            Swal.showLoading();
        },
        success: function (response) {
            Swal.close();
            window.location.href = '<?= base_url('vwarga/pembayaranselesai') ?>';
        },
        error: function () {
            Swal.fire({
                text:'Upload gagal, coba lagi.',
                icon : 'error'
            });
            $('#btnNext').prop('disabled', false).text('Next');
        }
    });
});
</script>

</body>
</html>